<?php
// ======================================================================
//  0. START SESSION
// ======================================================================
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// ======================================================================
//  1. INITIALIZE & SETUP
// ======================================================================
require_once 'db-config.php';

// --- CONFIGURATION ---
$admin_email = "rftravelsandtours@gmail.com";
$whatsapp_number = "923052394810";

// ======================================================================
//  2. HANDLE AGENT REFERRAL LINK
// ======================================================================
if (isset($_GET['ref']) && !empty($_GET['ref'])) {
    $_SESSION['referring_agent_id'] = (int)$_GET['ref'];
}

// ======================================================================
//  3. HANDLE BOOKING FORM SUBMISSION (WITH COMMISSION TRACKING)
// ======================================================================
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['request_booking'])) {
    $customer_name = trim($_POST['customer_name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $phone_number = trim($_POST['phone'] ?? '');
    $room_type = $_POST['room_type'] ?? 'Sharing';
    $pax = (int)($_POST['party_size'] ?? 1);
    $package_id_from_page = $_POST['package_id'] ?? 'Unknown';
    $package_name_from_page = $_POST['package_name'] ?? 'Unknown';

    if (empty($customer_name) || empty($email) || empty($phone_number) || !filter_var($email, FILTER_VALIDATE_EMAIL) || $package_id_from_page === 'Unknown') {
        $_SESSION['form_message'] = "Please fill in all required fields with valid information.";
        $_SESSION['form_msg_type'] = "error";
        header("Location: " . basename(__FILE__) . "?id=" . urlencode($package_id_from_page) . "#booking-form-anchor");
        exit();
    }

    $user_id_to_save = isset($_SESSION['user_id']) ? (int)$_SESSION['user_id'] : null;
    $referred_by_agent_id = isset($_SESSION['referring_agent_id']) ? (int)$_SESSION['referring_agent_id'] : null;
    $status_to_save = 'Pending';

    $conn->begin_transaction();
    try {
        $sql1 = "INSERT INTO umrah_inquiries (package_id, package_name, customer_name, customer_phone, customer_email, room_type, pax, user_id, referred_by_agent_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt1 = $conn->prepare($sql1);
        $stmt1->bind_param(
    "ssssssiii",
    $package_id_from_page,
    $package_name_from_page,
    $customer_name,
    $phone_number,
    $email,
    $room_type,
    $pax,
    $user_id_to_save,
    $referred_by_agent_id
);
        $stmt1->execute();
        $stmt1->close();

        $notification_type = "New Umrah Inquiry";
        $notification_message = "Inquiry for " . htmlspecialchars($package_name_from_page) . " from " . htmlspecialchars($customer_name) . ".";
        if ($referred_by_agent_id) {
            $notification_message .= " (Referred by Agent ID: " . $referred_by_agent_id . ")";
        }
        $notification_link = "admin/view-inquiries.php";
        $sql2 = "INSERT INTO notifications (type, message, link) VALUES (?, ?, ?)";
        $stmt2 = $conn->prepare($sql2);
        $stmt2->bind_param("sss", $notification_type, $notification_message, $notification_link);
        $stmt2->execute();
        $stmt2->close();

        $conn->commit();

        if (isset($_SESSION['referring_agent_id'])) {
            unset($_SESSION['referring_agent_id']);
        }
        
        // --- DATA FOR DYNAMIC WHATSAPP REDIRECT ---
        $_SESSION['submission_success'] = true;
        $_SESSION['booking_type'] = 'umrah'; // <-- The new dynamic key
        $_SESSION['success_context_name'] = $customer_name;
        $_SESSION['success_package_name'] = $package_name_from_page;
        $_SESSION['success_package_id'] = $package_id_from_page;
        $_SESSION['success_pax'] = $pax;
        $_SESSION['success_room_type'] = $room_type;
        // --- END OF NEW DATA ---

        header("Location: thank-you.php");
        exit();

    } catch (mysqli_sql_exception $exception) {
        $conn->rollback();
        error_log("Booking Form Database Error: " . $exception->getMessage());
        $_SESSION['form_message'] = "A server error occurred. Our team has been notified. Please try again later.";
        $_SESSION['form_msg_type'] = "error";
        header("Location: " . basename(__FILE__) . "?id=" . urlencode($package_id_from_page) . "#booking-form-anchor");
        exit();
    }
}

// ======================================================================
//  4. FETCH PACKAGE DATA FOR DISPLAY
// ======================================================================
if (!isset($_GET['id']) || empty(trim($_GET['id']))) {
    http_response_code(400);
    die("Error: No package ID was specified.");
}
$package_code_to_display = trim($_GET['id']);
$package = null;
try {
    $sql = "SELECT up.*, a.airline_name, a.logo_url FROM umrah_packages up LEFT JOIN airlines a ON up.airline_id = a.id WHERE up.package_id = ?";
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        throw new Exception("DB prepare failed: " . $conn->error);
    }
    $stmt->bind_param("s", $package_code_to_display);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        $package = $result->fetch_assoc();
    }
    $stmt->close();
} catch (Exception $e) {
    error_log("Package Fetch Error: " . $e->getMessage());
    die("A database error occurred while fetching package details.");
}
if ($package === null) {
    http_response_code(404);
    die("Error: Package with ID '" . htmlspecialchars($package_code_to_display) . "' could not be found.");
}

$booking_message = '';
if (isset($_SESSION['form_message'])) {
    $msg_type = $_SESSION['form_msg_type'] === 'error' ? 'error' : 'success';
    $booking_message = '<div class="notice ' . $msg_type . '">' . htmlspecialchars($_SESSION['form_message']) . '</div>';
    unset($_SESSION['form_message'], $_SESSION['form_msg_type']);
}

// ======================================================================
//  5. HELPER FUNCTION (FIXED FOR THE DEPRECATED WARNING)
// ======================================================================
function echo_list_items($text) {
    // FIX: Check if $text is null or not a string before attempting to trim it.
    if ($text === null || !is_string($text) || trim($text) === '') {
        return;
    }
    
    $items = explode("\n", trim($text));
    foreach ($items as $item) {
        $trimmed_item = trim($item);
        if (!empty($trimmed_item)) {
            echo "<li>" . htmlspecialchars($trimmed_item) . "</li>\n";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($package['package_name']) ?> - RF Travel & Tours</title>
    <link rel="icon" type="image/png" href="images/logo-icon.png">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.css" />
    <style>
        .notice { padding: 15px 20px; margin-bottom: 20px; border-radius: 8px; border: 1px solid transparent; }
        .notice.success { color: #155724; background-color: #d4edda; border-color: #c3e6cb; }
        .notice.error { color: #721c24; background-color: #f8d7da; border-color: #f5c6cb; }
        #flyerModal { display: none; position: fixed; z-index: 1001; left: 0; top: 0; width: 100%; height: 100%; background-color: rgba(0, 0, 0, 0.8); backdrop-filter: blur(5px); align-items: center; justify-content: center; padding: 1rem; }
        .modal-content { position: relative; background-color: var(--primary-dark, #2a2a2a); color: #fff; padding: 2rem; border-radius: 16px; width: 100%; max-width: 600px; text-align: center; box-shadow: 0 10px 30px rgba(0, 0, 0, 0.5); }
        #flyerModalImage { display: block; width: 100%; max-height: 65vh; object-fit: contain; border-radius: 8px; margin-bottom: 1.5rem; }
        .modal-main-title { font-size: 1.5rem; font-weight: 600; color: #fff; margin-top: 0; margin-bottom: 0.25rem; }
        .modal-sub-title { font-size: 1rem; font-weight: 400; color: rgba(255, 255, 255, 0.7); margin-top: 0; margin-bottom: 2rem; }
        .close-btn { color: #fff; position: absolute; top: 15px; right: 15px; font-size: 28px; font-weight: bold; cursor: pointer; line-height: 1; opacity: 0.7; transition: opacity 0.2s; }
        .close-btn:hover { opacity: 1; }
        #saveFlyerBtn { background-color: #007bff; color: white; padding: 14px 30px; text-decoration: none; border: none; border-radius: 8px; display: inline-flex; align-items: center; font-weight: 600; font-size: 1rem; transition: background-color 0.2s; cursor: pointer; }
        #saveFlyerBtn:hover { background-color: #0056b3; }
        #saveFlyerBtn i { margin-right: 10px; font-size: 1.1rem; }
        .btn-secondary { background: var(--primary-dark); color: white; padding: 10px 15px; border-radius: 8px; border: none; cursor: pointer; font-size: 1rem; transition: background-color 0.2s; }
        .btn-secondary:hover { background-color: #000; }
        .login-prompt { text-align: center; font-size: 0.9rem; color: var(--text-light); margin-top: 15px; }
        .login-prompt a { color: var(--primary-gold); font-weight: 600; text-decoration: none; }
        .input-with-icon { position: relative; }
        .input-with-icon .fa-solid { position: absolute; left: 15px; top: 50%; transform: translateY(-50%); color: #aaa; pointer-events: none; }
        .input-with-icon .booking-input { padding-left: 45px !important; }
        
        .agent-share-panel { background-color: #fff8e1; border: 1px solid #ffecb3; border-left: 5px solid #ffc107; padding: 20px; margin: 25px 0; border-radius: 8px; }
        .agent-share-panel h3 { margin-top: 0; font-size: 1.2rem; color: #333; }
        .agent-share-panel p { margin: 5px 0 15px 0; font-size: 0.9rem; color: #555; }
        .share-link-wrapper { display: flex; gap: 10px; }
        .share-link-input { flex-grow: 1; padding: 10px; font-size: 0.9rem; border: 1px solid #ccc; border-radius: 5px; background-color: #fff; color: #333; }
        .copy-link-btn { padding: 10px 20px; font-weight: 600; background-color: var(--primary-gold, #cfa968); color: white; border: none; border-radius: 5px; cursor: pointer; transition: background-color 0.2s; }
        .copy-link-btn:hover { background-color: #b89354; }
        .copy-link-btn i { margin-right: 8px; }
    </style>
</head>

<body>
    <?php include 'header.php'; ?>
    <main class="tour-detail-page">
        <div class="container">
            <div class="tour-layout-grid">
                <div class="tour-main-content">
                    <?= $booking_message ?>
                    <div class="tour-header">
                        <h1><?= htmlspecialchars($package['package_name']) ?></h1>
                        <div class="tour-meta-info"> <span>Package Code: <?= htmlspecialchars($package['package_id']) ?></span> </div>
                    </div>

                    <?php if (isset($_SESSION['user_type']) && $_SESSION['user_type'] === 'agent'): ?>
                        <section class="agent-share-panel">
                            <h3><i class="fa-solid fa-share-nodes"></i> Your Agent Sharing Link</h3>
                            <p>Share this unique link with your customers. Any bookings made through it will be credited to you for commission.</p>
                            <div class="share-link-wrapper">
                                <?php
                                $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
                                $page_name = basename(__FILE__);
                                $base_url = "$protocol://$_SERVER[HTTP_HOST]/" . $page_name . '?id=' . urlencode($package['package_id']);
                                $referral_link = $base_url . '&ref=' . urlencode($_SESSION['user_id']);
                                ?>
                                <input type="text" value="<?= htmlspecialchars($referral_link) ?>" id="referralLinkInput" class="share-link-input" readonly>
                                <button class="copy-link-btn" id="copyLinkBtn"><i class="fa-solid fa-copy"></i> Copy</button>
                            </div>
                        </section>
                    <?php endif; ?>

                    <div class="image-gallery">
                        <div class="gallery-main-image"> <img src="<?= htmlspecialchars($package['main_image_link']) ?>" alt="Main image for <?= htmlspecialchars($package['package_name']) ?>"> </div>
                        <div class="gallery-thumbnails">
                            <img src="./images/banner-2.jpg" alt="Gallery image 1">
                            <img src="./images/banner-3.jpg" alt="Gallery image 2">
                            <img src="./images/banner-4.jpg" alt="Gallery image 3">
                            <img src="./images/banner-5.jpg" style="display: block; width: 100%;" class="hide-mobile">
                        </div>
                    </div>
                    <aside class="mobile-form mobile-only tour-booking-sidebar" style="display: none;" id="mobile-booking-sidebar">
                        <div class="booking-card" id="booking-form-anchor-mobile">
                            <div class="booking-price">Book Now</div>
                            <form action="" method="POST" class="booking-form">
                                <input type="hidden" name="request_booking" value="1"> <input type="hidden" name="package_id" value="<?= htmlspecialchars($package['package_id']) ?>"> <input type="hidden" name="package_name" value="<?= htmlspecialchars($package['package_name']) ?>">
                                <div class="form-group">
                                    <label for="customer_name_mobile">Full Name:</label>
                                    <div class="input-with-icon">
                                        <i class="fa-solid fa-user"></i>
                                        <input type="text" id="customer_name_mobile" name="customer_name" class="booking-input" placeholder="Enter your full name" required>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="phone_mobile">Phone Number:</label>
                                    <div class="input-with-icon">
                                        <i class="fa-solid fa-phone"></i>
                                        <input type="tel" id="phone_mobile" name="phone" class="booking-input" placeholder="Enter your phone number" required>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="email_mobile">Email Address:</label>
                                    <div class="input-with-icon">
                                        <i class="fa-solid fa-envelope"></i>
                                        <input type="email" id="email_mobile" name="email" class="booking-input" placeholder="Enter your email address" required>
                                    </div>
                                </div>
                                <div class="form-group"><label for="room-type-mobile">Room Type:</label>
                                    <select id="room-type-mobile" name="room_type" class="booking-input">
                                        <?php if (!empty($package['price_quint'])) : ?><option value="Sharing">Sharing</option><?php endif; ?>
                                        <?php if (!empty($package['price_quad'])) : ?><option value="Quad">Quad</option><?php endif; ?>
                                        <?php if (!empty($package['price_triple'])) : ?><option value="Triple">Triple</option><?php endif; ?>
                                        <?php if (!empty($package['price_double'])) : ?><option value="Double">Double</option><?php endif; ?>
                                    </select>
                                </div>
                                <div class="form-group"><label>Total Pax:</label>
                                    <div class="party-size-selector"><button type="button" class="party-btn minus">-</button><input type="text" name="party_size" value="1" readonly><button type="button" class="party-btn plus">+</button></div>
                                </div>
                                <button type="submit" class="btn-booking">Request Booking</button>
                            </form>
                        </div>
                    </aside>
                    <section class="guide-info-card">
                        <div class="guide-avatar"><i class="fa-solid fa-headset fa-2x"></i></div>
                        <div class="guide-details"><span>Unsure? Talk to our Umrah Experts</span>
                            <h3>We are here to answer all your questions.</h3>
                            <div class="tour-rating"><i class="fa-solid fa-clock"></i> Available 24/7</div>
                        </div>
                        <div class="guide-message"> <a href="https://wa.me/<?= $whatsapp_number ?>?text=<?= urlencode('I am interested in the ' . $package['package_name']) ?>" target="_blank" class="btn-message"><i class="fa-brands fa-whatsapp"></i> Message Us</a> </div>
                    </section>
                    <section class="tour-section">
                        <h2>Overview of Your <?= htmlspecialchars($package['days']) ?>-Day Umrah Package:</h2>
                        <p><?= nl2br(htmlspecialchars($package['overview'])) ?></p>
                        <?php
                        $flyer_path_for_check = str_replace('../', '', $package['flyer_image_path'] ?? '');
                        $flyer_path_for_browser = $flyer_path_for_check;
                        if (!empty($package['flyer_image_path']) && file_exists($flyer_path_for_check)) :
                        ?>
                            <div style="margin-top: 25px; margin-bottom: 10px;">
                                <button id="viewFlyerBtn" class="btn-secondary" data-flyer-url="<?= htmlspecialchars($flyer_path_for_browser) ?>">
                                    <i class="fa-solid fa-image"></i> View Package Flyer
                                </button>
                            </div>
                        <?php endif; ?>
                    </section>
                    <div class="booking-card">
                        <div class="price-grid-header">
                            <h3>Package Pricing (per person)</h3>
                        </div>
                        <div class="umrah-pricing-grid"> <?php if (!empty($package['price_quint'])) : ?><div class="price-cell"><label>Sharing</label><strong>PKR <?= number_format($package['price_quint']) ?>/-</strong></div><?php endif; ?> <?php if (!empty($package['price_quad'])) : ?><div class="price-cell"><label>Quad</label><strong>PKR <?= number_format($package['price_quad']) ?>/-</strong></div><?php endif; ?> <?php if (!empty($package['price_triple'])) : ?><div class="price-cell"><label>Triple</label><strong>PKR <?= number_format($package['price_triple']) ?>/-</strong></div><?php endif; ?> <?php if (!empty($package['price_double'])) : ?><div class="price-cell"><label>Double</label><strong>PKR <?= number_format($package['price_double']) ?>/-</strong></div><?php endif; ?> </div>
                    </div>
                    <?php if (!empty($package['outbound_flight_details']) || !empty($package['inbound_flight_details'])) : ?>
                        <section class="tour-section">
                            <h2>Flight Details</h2>
                            <?php if (!empty($package['airline_name'])): ?>
                                <div class="airline-details" style="display: flex; align-items: center; gap: 15px; margin-bottom: 25px; background-color: #f9f9f9; padding: 15px; border-radius: 8px; border: 1px solid #eee;">
                                    <?php if (!empty($package['logo_url'])): ?>
                                        <img src="<?= htmlspecialchars($package['logo_url']) ?>" alt="<?= htmlspecialchars($package['airline_name']) ?> Logo" style="max-height: 40px; border-radius: 5px;">
                                    <?php endif; ?>
                                    <div>
                                        <h4 style="margin: 0 0 4px 0; color: #555; font-size: 0.9rem; font-weight: 500;">Airline</h4>
                                        <p style="margin: 0; font-size: 1.2rem; font-weight: 600; color: #222;"><?= htmlspecialchars($package['airline_name']) ?></p>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if (!empty($package['outbound_flight_details'])) : ?>
                                <h4><i class="fa-solid fa-plane-departure"></i> Outbound</h4>
                                <p><?= nl2br(htmlspecialchars($package['outbound_flight_details'])) ?></p>
                            <?php endif; ?>
                            <?php if (!empty($package['inbound_flight_details'])) : ?>
                                <h4><i class="fa-solid fa-plane-arrival"></i> Inbound</h4>
                                <p><?= nl2br(htmlspecialchars($package['inbound_flight_details'])) ?></p>
                            <?php endif; ?>
                        </section>
                    <?php endif; ?>
                    <section class="tour-section">
                        <h2>Your <?= htmlspecialchars($package['days']) ?>-Day Umrah Itinerary</h2>
                        <p>This is a suggested itinerary and may be adjusted based on flight schedules or personal needs.</p>
                        <ul><?php echo_list_items($package['itinerary']); ?></ul>
                    </section>
                    <div class="customize-tour-banner">
                        <h3>Customize your package</h3>
                        <p>Contact us to know more!</p>
                    </div>
                    <section class="tour-section">
                        <h2>Transportation Details</h2>
                        <p><strong>Type:</strong> <?= htmlspecialchars($package['transportation']) ?></p>
                        <h2>What's included</h2>
                        <ul><?php echo_list_items($package['whats_included']); ?></ul>
                        <h2>What's extra</h2>
                        <ul><?php echo_list_items($package['whats_extra']); ?></ul>
                        <h2>Ziyarat</h2>
                        <p><strong>Included:</strong> <?= htmlspecialchars($package['ziyarat']) ?></p>
                    </section>
                    <section class="tour-section">
                        <h2>Other Details</h2>
                        <div class="details-grid">
                            <div><strong>Tour categories:</strong> <span class="tag">Religious</span> <span class="tag">Pilgrimage</span></div>
                            <div><strong>Languages:</strong> Urdu, Arabic, Basic English</div>
                            <div><strong>Activity level:</strong>
                                <div class="activity-level minimal"></div> Moderate
                            </div>
                        </div>
                    </section>
                </div>
                <aside class="desktop-form tour-booking-sidebar" style="display:block;">
                    <div class="booking-card" id="booking-form-anchor">
                        <div class="booking-price">Book Now</div>
                        <form action="" method="POST" class="booking-form">
                            <input type="hidden" name="request_booking" value="1"> <input type="hidden" name="package_id" value="<?= htmlspecialchars($package['package_id']) ?>"> <input type="hidden" name="package_name" value="<?= htmlspecialchars($package['package_name']) ?>">
                            <div class="form-group">
                                <label for="customer_name">Full Name:</label>
                                <div class="input-with-icon">
                                    <i class="fa-solid fa-user"></i>
                                    <input type="text" id="customer_name" name="customer_name" class="booking-input" placeholder="Enter your full name" required>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="phone">Phone Number:</label>
                                <div class="input-with-icon">
                                    <i class="fa-solid fa-phone"></i>
                                    <input type="tel" id="phone" name="phone" class="booking-input" placeholder="Enter your phone number" required>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="email">Email Address:</label>
                                <div class="input-with-icon">
                                    <i class="fa-solid fa-envelope"></i>
                                    <input type="email" id="email" name="email" class="booking-input" placeholder="Enter your email address" required>
                                </div>
                            </div>
                            <div class="form-group"><label for="room-type">Room Type:</label>
                                <select id="room-type" name="room_type" class="booking-input">
                                    <?php if (!empty($package['price_quint'])) : ?><option value="Sharing">Sharing</option><?php endif; ?>
                                    <?php if (!empty($package['price_quad'])) : ?><option value="Quad">Quad</option><?php endif; ?>
                                    <?php if (!empty($package['price_triple'])) : ?><option value="Triple">Triple</option><?php endif; ?>
                                    <?php if (!empty($package['price_double'])) : ?><option value="Double">Double</option><?php endif; ?>
                                </select>
                            </div>
                            <div class="form-group"><label>Total Pax:</label>
                                <div class="party-size-selector"><button type="button" class="party-btn minus">-</button><input type="text" id="party-size-input" name="party_size" value="1" readonly><button type="button" class="party-btn plus">+</button></div>
                            </div>
                            <button type="submit" class="btn-booking">Request Booking</button>
                            <?php if (!isset($_SESSION['user_id'])) : ?>
                                <p class="login-prompt">
                                    <a href="login.php">Login</a> for a better experience.
                                </p>
                            <?php endif; ?>
                        </form>
                    </div>
                </aside>
            </div>
        </div>
    </main>
    <div id="flyerModal">
        <div class="modal-content">
            <span class="close-btn">×</span>
            <p class="modal-main-title">Package Flyer</p>
            <p class="modal-sub-title">Package Flyer Preview</p>
            <img id="flyerModalImage" src="" alt="Package Flyer Preview">
            <button id="saveFlyerBtn" type="button">
                <i class="fa-solid fa-download"></i> Save as Image
            </button>
        </div>
    </div>
    <?php if (file_exists('footer.php')) {
        include 'footer.php';
    } ?>
    <script src="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const hamburger = document.getElementById('hamburger');
            if (hamburger) {
                hamburger.addEventListener('click', () => {
                    const navMenu = document.getElementById('nav-menu');
                    if (navMenu) {
                        navMenu.classList.toggle('active');
                    }
                    hamburger.classList.toggle('active');
                });
            }

            document.querySelectorAll('.party-size-selector').forEach(selector => {
                const minusBtn = selector.querySelector('.party-btn.minus');
                const plusBtn = selector.querySelector('.party-btn.plus');
                const partyInput = selector.querySelector('input[type="text"]');
                if (minusBtn && plusBtn && partyInput) {
                    minusBtn.addEventListener('click', () => {
                        let value = parseInt(partyInput.value, 10);
                        if (value > 1) {
                            partyInput.value = value - 1;
                        }
                    });
                    plusBtn.addEventListener('click', () => {
                        let value = parseInt(partyInput.value, 10);
                        partyInput.value = value + 1;
                    });
                }
            });

            const datePickers = document.querySelectorAll(".booking-input[placeholder='Select a date']");
            if (datePickers.length > 0) {
                flatpickr(datePickers, {
                    altInput: true,
                    altFormat: "F j, Y",
                    dateFormat: "Y-m-d",
                    minDate: "today"
                });
            }

            const copyBtn = document.getElementById('copyLinkBtn');
            const linkInput = document.getElementById('referralLinkInput');
            if (copyBtn && linkInput) {
                copyBtn.addEventListener('click', function() {
                    linkInput.select();
                    linkInput.setSelectionRange(0, 99999);
                    navigator.clipboard.writeText(linkInput.value).then(() => {
                        copyBtn.innerHTML = '<i class="fa-solid fa-check"></i> Copied!';
                        setTimeout(() => {
                            copyBtn.innerHTML = '<i class="fa-solid fa-copy"></i> Copy';
                        }, 2000);
                    }).catch(err => {
                        console.error('Failed to copy text: ', err);
                    });
                });
            }

            const viewFlyerBtn = document.getElementById('viewFlyerBtn');
            const flyerModal = document.getElementById('flyerModal');
            if (viewFlyerBtn && flyerModal) {
                const closeBtn = flyerModal.querySelector('.close-btn');
                const modalImage = document.getElementById('flyerModalImage');
                const saveBtn = document.getElementById('saveFlyerBtn');
                let currentFlyerUrl = '';

                viewFlyerBtn.addEventListener('click', () => {
                    currentFlyerUrl = viewFlyerBtn.dataset.flyerUrl;
                    if (currentFlyerUrl) {
                        modalImage.src = currentFlyerUrl;
                        flyerModal.style.display = 'flex';
                    }
                });

                const closeModal = () => {
                    flyerModal.style.display = 'none';
                };
                closeBtn.addEventListener('click', closeModal);
                flyerModal.addEventListener('click', (event) => {
                    if (event.target === flyerModal) {
                        closeModal();
                    }
                });
                document.addEventListener('keydown', (event) => {
                    if (event.key === "Escape" && flyerModal.style.display === 'flex') {
                        closeModal();
                    }
                });

                saveBtn.addEventListener('click', async () => {
                    if (!currentFlyerUrl) return;
                    try {
                        const response = await fetch(currentFlyerUrl);
                        const blob = await response.blob();
                        const link = document.createElement('a');
                        link.href = URL.createObjectURL(blob);
                        const filename = currentFlyerUrl.split('/').pop() || 'package-flyer.jpg';
                        link.download = filename;
                        document.body.appendChild(link);
                        link.click();
                        document.body.removeChild(link);
                        URL.revokeObjectURL(link.href);
                    } catch (error) {
                        console.error('Download failed:', error);
                        alert('Could not download the flyer. Please check your connection and try again.');
                    }
                });
            }
        });
    </script>
</body>
</html>