<?php
// We need to start the session to show the correct header state (logged in/out)
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
?>
<!DOCTYPE html>
<html>

<head>
    <title>About Us - RF Travel & Tours</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Main Stylesheet (for variables) -->
    <link rel="stylesheet" href="css/style.css">
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css">
    <!-- The dedicated stylesheet for this page -->
    <link rel="stylesheet" href="css/about-style.css">
</head>

<body>

    <?php include 'header.php'; ?>

    <!-- ========== HERO SECTION ========== -->
    <section class="about-hero-section">
        <div class="hero-content">
            <h1>Your Trusted Partner in Global Travel</h1>
            <p>Discover the world with confidence. At RF Travel & Tours, we turn your travel dreams into reality.</p>
        </div>
    </section>

    <main class="about-page-wrapper">
        <div class="container">
            <!-- ========== OUR STORY SECTION ========== -->
            <section class="about-section">
                <h2 class="section-title">Our Story</h2>
                <p class="section-intro">
                    Founded with a passion for connecting people and places, RF Travel & Tours has grown from a humble beginning into a premier travel service provider. Our journey is fueled by a commitment to excellence and a deep understanding of the traveler's needs. We believe that travel is more than just visiting a destination; it's about creating lasting memories and enriching experiences.
                </p>

                <div class="mission-vision-grid">
                    <div class="info-card">
                        <i class="fa-solid fa-rocket"></i>
                        <h3>Our Mission</h3>
                        <p>To provide seamless, reliable, and personalized travel solutions that exceed expectations. We strive to offer the best value and expert guidance, ensuring every journey is smooth, enjoyable, and unforgettable.</p>
                    </div>
                    <div class="info-card">
                        <i class="fa-solid fa-eye"></i>
                        <h3>Our Vision</h3>
                        <p>To be the most trusted and innovative travel agency in the region, renowned for our exceptional customer service, exclusive deals, and dedication to making travel accessible and hassle-free for everyone.</p>
                    </div>
                </div>
            </section>

            <!-- ========== WHY CHOOSE US SECTION ========== -->
            <section class="about-section why-choose-us">
                <h2 class="section-title">Why Choose Us?</h2>
                <div class="features-grid">
                    <div class="feature-item">
                        <div class="feature-icon"><i class="fa-solid fa-user-tie"></i></div>
                        <h4>Expert Agents</h4>
                        <p>Our team of experienced travel professionals is dedicated to crafting the perfect itinerary for you.</p>
                    </div>
                    <div class="feature-item">
                        <div class="feature-icon"><i class="fa-solid fa-tags"></i></div>
                        <h4>Exclusive Deals</h4>
                        <p>We leverage our industry partnerships to bring you unbeatable prices on flights and packages.</p>
                    </div>
                    <div class="feature-item">
                        <div class="feature-icon"><i class="fa-solid fa-headset"></i></div>
                        <h4>24/7 Support</h4>
                        <p>Travel with peace of mind knowing our support team is always here to assist you, anytime, anywhere.</p>
                    </div>
                </div>
            </section>

        </div>
    </main>
    <?php include 'floating-icon.php'; ?>

    <?php include 'footer.php'; ?>


</body>

</html>