<?php
// This ensures session is started, which is needed for user info
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Security check - if not logged in as admin, kick out.
if (!isset($_SESSION['user_id']) || !isset($_SESSION['user_type']) || $_SESSION['user_type'] !== 'admin') {
    header("location: login.php");
    exit;
}

// A helper function for safely displaying text
function e($string) {
    return htmlspecialchars($string ?? '', ENT_QUOTES, 'UTF-8');
}
?>
<header class="main-header">
    <button class="menu-toggle" id="menu-toggle">
        <i class="fas fa-bars"></i>
    </button>
    <div class="user-info">
        <span>Welcome, <strong><?php echo e($_SESSION['user_name'] ?? 'Admin'); ?></strong></span>
    </div>
</header>