<?php
session_start();
include_once '../db-config.php'; // Ensure this path is correct

// --- SECURITY CHECK ---
if (!isset($_SESSION['user_id']) || !isset($_SESSION['user_type']) || $_SESSION['user_type'] !== 'admin') {
    header("location: ../login.php");
    exit;
}

// --- 1. VALIDATE AND GET VOUCHER ID ---
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("Invalid Voucher ID.");
}
$voucher_id = (int)$_GET['id'];

// Helper function for safe output
function e($string)
{
    return htmlspecialchars($string ?? '', ENT_QUOTES, 'UTF-8');
}

// --- 2. FETCH ALL DATA FROM DATABASE ---
$stmt = $conn->prepare("SELECT * FROM vouchers WHERE id = ?");
$stmt->bind_param("i", $voucher_id);
$stmt->execute();
$voucher = $stmt->get_result()->fetch_assoc();

if (!$voucher) {
    die("Voucher not found.");
}

$agent_name = '';
$agent_logo_path = '';
if (!empty($voucher['user_id'])) {
    $stmt_agent = $conn->prepare("SELECT name, logo_path FROM users WHERE id = ?");
    $stmt_agent->bind_param("i", $voucher['user_id']);
    $stmt_agent->execute();
    $agent_result = $stmt_agent->get_result()->fetch_assoc();
    if ($agent_result) {
        $agent_name = $agent_result['name'];
        $agent_logo_path = $agent_result['logo_path'];
    }
}

$stmt_accom = $conn->prepare("SELECT * FROM voucher_accommodations WHERE voucher_id = ? ORDER BY check_in_date ASC");
$stmt_accom->bind_param("i", $voucher_id);
$stmt_accom->execute();
$accommodations = $stmt_accom->get_result()->fetch_all(MYSQLI_ASSOC);

$stmt_mutamer = $conn->prepare("SELECT * FROM voucher_mutamers WHERE voucher_id = ? ORDER BY id ASC");
$stmt_mutamer->bind_param("i", $voucher_id);
$stmt_mutamer->execute();
$mutamers = $stmt_mutamer->get_result()->fetch_all(MYSQLI_ASSOC);

$stmt_flight = $conn->prepare("SELECT * FROM voucher_flights WHERE voucher_id = ?");
$stmt_flight->bind_param("i", $voucher_id);
$stmt_flight->execute();
$flights_data = $stmt_flight->get_result()->fetch_all(MYSQLI_ASSOC);

$departure_flight = null;
$arrival_flight = null;
foreach ($flights_data as $flight) {
    if ($flight['direction'] == 'Pakistan To KSA') {
        $departure_flight = $flight;
    } else if ($flight['direction'] == 'KSA To Pakistan') {
        $arrival_flight = $flight;
    }
}

// --- QR CODE URL GENERATION ---
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";
$host = $_SERVER['HTTP_HOST'];
$base_path = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
$base_path = str_replace('/admin', '', $base_path); 
$online_voucher_url = $protocol . "://" . $host . $base_path . "/online-voucher.php?id=" . $voucher_id;
$qr_code_url = "https://api.qrserver.com/v1/create-qr-code/?size=80x80&data=" . urlencode($online_voucher_url);

$urdu_note_text = "ضروری ہدایات
* آپ کا ہوٹل اور پیکج اس دستاویز میں لکھ دیا گیا ہے، اس کے مطابق آپ کو رہائش اور دیگر سہولیات فراہم کی جائیں گی۔
* نشہ آور اشياء شرعاً اور قانوناً ممنوع ہيں، سعودی عرب ميں منشيات لے جانے کی سزا موت ہے۔
* حرمین شریفین کے اندر زمين پر گری پڑی چيز (پرس، موبائل، یا کوئی اور قيمتی چيز) ہرگز نہ اٹھائيں ورنہ آپ مشکل میں پڑ سکتے ہيں۔
* جدہ ایئر پورٹ پر اميگريشن، سعودی وزارت و سعودی کمپنی کے انتظامات ميں 3 سے 5 گھنٹے لگ سکتے ہيں، اس لئے جدہ ایئر پورٹ سے سعودی سم خریديں اور اپنے گھر والوں کو خيريت سے پہنچنے کی اطلاع دے ديں۔
* عمرہ زائرین جدہ ایئر پورٹ سے مکہ جانے کیلئے صرف اپنے ويزہ پر موجود شرکہ کی بسوں میں سفر کريں۔
* سعودیہ میں معتمرین سے پاسپورٹ لینے کی اجازت کسی کو نہیں ہے، لہذا اپنا پاسپورٹ اپنے پاس سنبھال کے رکھیں۔
* پاسپورٹ گم ہونے کی صورت میں آؤٹ پاس اور ٹکٹ کے چارجز معتمر کو دینے ہوں گے۔
* ہوٹل چیک ان ٹائم 4:00 بجے اور ہوٹل چیک آؤٹ ٹائم 2:00 بجے ہے، البتہ مدینے شریف میں کمرہ خالی ہونے اور صفائی کی صورت میں کچھ دیر مزید انتظار کرنا پڑ سکتا ہے۔
* معتمرین واؤچر پر درج شیڈول یا ادارے کے اسٹاف کی طرف سے دیئے گئے روانگی اوقات پر عمل کرنے کے پابند ہوں گے۔
* ہوٹل واؤچر کی 2 عدد کاپياں اپنے ہمراہ لازمی رکھيں۔
* واپسی کی فلائٹ سے 10 گھنٹے قبل مسافر اپنے سامان کے ساتھ رسيپشن پر موجود رہيں۔
* معتمر کو مکہ مکرمہ سے مدینہ شریف، مدینہ شریف سے مکہ مکرمہ اور مکہ مکرمہ سے ایئر پورٹ روانگی سے 24 گھنٹے پہلے اسٹاف کو روانگی شیڈول نوٹ کروانا ہو گا۔ 
* مدینے شریف روانگی کے لئے صبح 7 بجے ہوٹل سے سامان اٹھا کر سٹاف کی طرف سے بس آنے کے بتائے گئے مقام پر آنا ضروری ہو گا۔
* سعودی قانون کے مطابق مکہ سے جدہ ایئر پورٹ روانگی کے لئے 8-10 گھنٹے پہلے ہوٹل چھوڑنا ہو گا۔
* کسی بھی سیکٹر کی ٹرانسپورٹ چھوٹ جانے پر دوبارہ فراہم نہیں کی جائے گی، دوبارہ ٹرانسپورٹ حاصل کرنے کے الگ چارجز ہوں گے۔
* فلائٹ چھوٹ جانے یا آگے بڑھ جانے کی صورت میں ادارہ ذمہ دار نہیں ہو گا، Extra Night کے الگ چارجز معتمر کو دینے ہوں گے۔
* سعودی قوانین اور پالیسی پر مکمل عملدرآمد کرنے کی ذمہ داری معتمرین پر عائد ہو گی۔
* سعودی قانون کے مطابق غير مصنف ہوٹلز میں قيام جرم ہے۔ اس ليئے کمپنی کے تصنيف شدہ ہوٹلز کا استعمال کريں۔
* غير تصنيف شدہ ہوٹلز کے استعمال کی وجہ سے اگر وزارت جرمانہ کرتی ہے تو وہ متعلقہ ایجنٹ سے وصول کیا جائے گا ( اگر کسٹمر ایجنٹ کی طرف سے ملا ہو ) وگرنہ ڈائریکٹ کسٹمر سے وصول کیا جائے گا۔
* کسی بھی پریشانی کی صورت میں معتمرین واؤچر پر درج شدہ سعودی سٹاف کے نمبرز پر رابطہ کریں۔
* نوٹ: مندرجہ بالا ہدایات پر علمدرامد کو یقینی بنائیں، کوتاہی کی صورت میں ہونے والے کسی بھی نقصان کی ذمہ داری معتمرین پر ہو گی۔";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Voucher #<?= e($voucher['manual_no']) ?></title>
    <link rel="icon" type="image/png" href="../images/logo-icon.png">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Arial&family=Noto+Nastaliq+Urdu:wght@400;700&display=swap" rel="stylesheet">
    <style>
        @font-face {
            font-family: 'Jameel Noori Nastaleeq';
            src: url('../fonts/Jameel-Noori-Nastaleeq.ttf') format('truetype');
            font-weight: normal;
            font-style: normal;
        }

        :root { --primary-color: #0d3769; }
        body { background-color: #e9ebee; font-family: Arial, sans-serif; font-size: 10px; color: #000; }
        .voucher-wrapper { width: 850px; margin: 25px auto; padding: 25px; background-color: #fff; border: 1px solid #000; position: relative; }
        .watermark { position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%) rotate(-45deg); font-size: 110px; font-weight: 700; color: <?php echo ($voucher['status'] == 'Tentative') ? 'rgba(255, 0, 0, 0.08)' : 'rgba(0, 128, 0, 0.08)'; ?>; z-index: 1; pointer-events: none; text-transform: uppercase; letter-spacing: 5px; }
        .content-container { position: relative; z-index: 2; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #000; padding: 4px 6px; vertical-align: middle; }
        .header-table td { border: none; vertical-align: middle; padding: 0; }
        .section-title { background-color: #000; color: #fff; text-align: center; font-weight: bold; padding: 5px; font-size: 12px; margin-top: 15px; }
        .details-grid .label { font-weight: bold; width: 120px; }
        .details-grid .value { font-weight: bold; color: var(--primary-color); }
        .data-table th { background-color: #f2f2f2; font-weight: bold; }
        .text-center { text-align: center; }
        .text-right { text-align: right; }
        .no-border { border: none !important; }
        .notes-box { margin-top: 15px; padding: 10px; border: 1px solid #000; }
        
        /* *** SPACING FIX *** */
        .urdu-notes-box { 
            margin-top: 15px; 
            padding: 10px; 
            border: 1px solid #000; 
            font-family: 'Jameel Noori Nastaleeq', 'Noto Nastaliq Urdu', sans-serif; 
            direction: rtl; 
            text-align: right; /* Changed from justify to right */
            font-size: 12pt;
            line-height: 2;
            white-space: pre-wrap; 
        }
        /* *** END FIX *** */

        .print-button-container { text-align: center; padding: 20px; }
        .print-button { background-color: var(--primary-color); color: white; border: none; padding: 12px 30px; font-size: 16px; cursor: pointer; }
        @media print {
            body { background-color: #fff; font-size: 9pt; }
            .no-print { display: none !important; }
            .voucher-wrapper { margin: 0; border: none; box-shadow: none; width: 100%; padding: 0; }
        }
    </style>
</head>
<body>
    <div class="print-button-container no-print">
        <button onclick="window.print()" class="print-button">Print Voucher</button>
        <a href="edit-voucher.php?id=<?= $voucher_id ?>" class="print-button" style="text-decoration:none; background-color: #f39c12;">Edit Voucher</a>
    </div>

    <div class="voucher-wrapper">
        <div class="watermark"><?= e($voucher['status']) ?></div>
        <div class="content-container">

           <!-- Rest of the HTML content remains the same -->
           <table class="header-table">
                <tr>
                    <td><a href="index.php"><img src="../images/logo.png" alt="Logo" style="height: 45px;"></a></td>
                    <td class="text-center">
                        <h1 style="margin:0; font-size: 14pt; color: var(--primary-color);"><?= e($agent_name ?: 'RF Travel & Tours') ?></h1>
                        <h2 style="margin:5px 0 0 0; padding: 2px 15px; border: 2px solid #000; display: inline-block; font-size: 12pt;">Hotel Voucher</h2>
                    </td>
                    <td style="width: 25%; text-align: right;">
                        <?php if (!empty($agent_logo_path)): ?>
                            <img src="../<?= e($agent_logo_path) ?>" alt="Agent Logo" style="max-height: 80px; max-width: 150px;">
                        <?php endif; ?>
                    </td>
                </tr>
            </table>
            <br>
            <table class="details-grid">
                <?php if (!empty($agent_name)): ?>
                <tr>
                    <td class="label">Agent:</td><td class="value" colspan="3"><?= e($agent_name) ?></td>
                </tr>
                <?php endif; ?>
                <?php if (!empty($voucher['shirka_name'])): ?>
                <tr>
                    <td class="label">Saudi Company:</td><td class="value" colspan="3"><?= e($voucher['shirka_name']) ?></td>
                </tr>
                <?php endif; ?>
                <tr>
                    <td class="label">Voucher No:</td><td class="value"><?= e($voucher['manual_no']) ?></td>
                    <td class="label">Date:</td><td class="value"><?= e($voucher['voucher_date'] ? date('d/m/Y', strtotime($voucher['voucher_date'])) : '') ?></td>
                </tr>
                <tr>
                    <td class="label">Family Head:</td><td class="value"><?= e($voucher['family_head_name']) ?></td>
                    <td class="label">Package:</td><td class="value"><?= e($voucher['package_type']) ?> (<?= e($voucher['package_duration_nights']) ?> Nights)</td>
                </tr>
                 <tr>
                    <td class="label">Total PAX:</td><td class="value" colspan="3"><?= e($voucher['pax_summary']) ?></td>
                </tr>
            </table>

            <div class="section-title">Pilgrims Details</div>
            <table class="data-table">
                <thead><tr><th>Mutamer Name</th><th class="text-center">Passport No</th><th class="text-center">PAX</th><th class="text-center">Beds</th><th class="text-center">Visa Number</th><th class="text-center">PNR</th></tr></thead>
                <tbody>
                    <?php $total_beds = 0; foreach ($mutamers as $mutamer): if (strtolower($mutamer['bed_required'] ?? '') == 'yes') { $total_beds++; } ?>
                        <tr><td><?= e($mutamer['mutamer_name']) ?></td><td class="text-center"><?= e($mutamer['passport_no']) ?></td><td class="text-center"><?= e($mutamer['pax_type']) ?></td><td class="text-center"><?= e($mutamer['bed_required']) ?></td><td class="text-center"><?= e($mutamer['visa_no']) ?></td><td class="text-center"><?= e($mutamer['pnr_no']) ?></td></tr>
                    <?php endforeach; ?>
                    <tr><td colspan="3" class="text-right" style="font-weight:bold;">Total PAX: <?= e(count($mutamers)) ?></td><td colspan="3" style="font-weight:bold;">Total BEDS: <?= $total_beds ?></td></tr>
                </tbody>
            </table>

            <?php if (!empty($accommodations)): ?>
                <div class="section-title">Accommodation Details</div>
                <table class="data-table">
                    <thead><tr><th>Hotel Name</th><th class="text-center">Confirm No</th><th class="text-center">City</th><th class="text-center">Room Type</th><th class="text-center">Meal Plan</th><th class="text-center">Check In</th><th class="text-center">Checkout</th><th class="text-center">Nights</th></tr></thead>
                    <tbody>
                        <?php foreach ($accommodations as $accom): ?>
                            <tr><td><?= e($accom['hotel_name']) ?></td><td class="text-center"><?= e($accom['confirmation_no']) ?></td><td class="text-center"><?= e($accom['city']) ?></td><td class="text-center"><?= e($accom['room_type']) ?></td><td class="text-center"><?= e($accom['meal_plan']) ?></td><td class="text-center"><?= e($accom['check_in_date'] ? date('d/m/Y', strtotime($accom['check_in_date'])) : '') ?></td><td class="text-center"><?= e($accom['check_out_date'] ? date('d/m/Y', strtotime($accom['check_out_date'])) : '') ?></td><td class="text-center"><?= e($accom['nights']) ?></td></tr>
                        <?php endforeach; ?>
                        <tr><td colspan="7" class="text-right" style="font-weight:bold;">Total Nights:</td><td class="text-center" style="font-weight:bold;"><?= e($voucher['package_duration_nights']) ?></td></tr>
                    </tbody>
                </table>
            <?php endif; ?>

            <?php if (!empty(trim($voucher['transport_description'] ?? ''))): ?>
                <div class="section-title">Transport / Services</div>
                <table class="data-table">
                    <thead><tr><th>Name</th><th class="text-center">Type</th><th class="text-center">BRN</th></tr></thead>
                    <tbody><tr><td><?= e($voucher['transport_description']) ?></td><td class="text-center"><?= e($voucher['transport_type']) ?></td><td class="text-center"><?= e($voucher['transport_brn']) ?></td></tr></tbody>
                </table>
            <?php endif; ?>
            
            <?php if ($departure_flight || $arrival_flight): ?>
            <table style="width:100%; margin-top:15px; border:none;">
                <tr>
                    <?php if ($departure_flight): ?>
                    <td style="width:50%; border:none; vertical-align:top; padding-right: 5px;">
                        <div class="section-title">Departure Flight</div>
                        <table class="data-table">
                            <thead><tr><th>Flight</th><th>Sector</th><th>Departure</th><th>Arrival</th></tr></thead>
                            <tbody><tr><td class="text-center"><?= e($departure_flight['flight_no'] ?? 'N/A') ?></td><td class="text-center"><?= e($departure_flight['sector'] ?? 'N/A') ?></td><td class="text-center"><?= e($departure_flight ? date('d-M H:i', strtotime($departure_flight['departure_datetime'])) : 'N/A') ?></td><td class="text-center"><?= e($departure_flight ? date('d-M H:i', strtotime($departure_flight['arrival_datetime'])) : 'N/A') ?></td></tr></tbody>
                        </table>
                    </td>
                    <?php endif; ?>
                    <?php if ($arrival_flight): ?>
                    <td style="width:50%; border:none; vertical-align:top; padding-left: 5px;">
                        <div class="section-title">Arrival Flight</div>
                        <table class="data-table">
                            <thead><tr><th>Flight</th><th>Sector</th><th>Departure</th><th>Arrival</th></tr></thead>
                            <tbody><tr><td class="text-center"><?= e($arrival_flight['flight_no'] ?? 'N/A') ?></td><td class="text-center"><?= e($arrival_flight['sector'] ?? 'N/A') ?></td><td class="text-center"><?= e($arrival_flight ? date('d-M H:i', strtotime($arrival_flight['departure_datetime'])) : 'N/A') ?></td><td class="text-center"><?= e($arrival_flight ? date('d-M H:i', strtotime($arrival_flight['arrival_datetime'])) : 'N/A') ?></td></tr></tbody>
                        </table>
                    </td>
                     <?php endif; ?>
                </tr>
            </table>
            <?php endif; ?>

            <div style="display: flex; justify-content: space-between; align-items: flex-end; margin-top: 15px;">
                <div class="notes-box" style="flex-grow: 1;">
                    <strong>Note:</strong><br>
                    <?php
                    $unique_cities = [];
                    foreach($accommodations as $acc) { if (!isset($unique_cities[$acc['city']])) { $unique_cities[$acc['city']] = []; } $unique_cities[$acc['city']][] = $acc; }
                    foreach($unique_cities as $city => $acc_details_list): 
                        foreach($acc_details_list as $acc_details):
                    ?>
                        <div style="margin-bottom: 5px;">
                            <strong><?= strtoupper(e($city)) ?> HOTEL CONTACT (<?= e($acc_details['hotel_name']) ?>):</strong> 
                            <?= e($acc_details['person_name']) ?> | 
                            Call: <?= e($acc_details['person_call_number']) ?> | 
                            WhatsApp: <?= e($acc_details['person_whatsapp_number']) ?>
                        </div>
                    <?php 
                        endforeach;
                    endforeach; 
                    ?>
                    <?php if (!empty(trim($voucher['transport_description'] ?? ''))): ?>
                        <div><strong>Transport Helpline:</strong> <?= e($voucher['transport_helpline_1']) ?> | <?= e($voucher['transport_helpline_2']) ?></div>
                    <?php endif; ?>
                </div>
                <div style="text-align: right; padding-left: 15px;">
                    <img src="<?= e($qr_code_url) ?>" alt="Scan to view online voucher">
                </div>
            </div>

            <div class="urdu-notes-box">
                <?= nl2br(e($urdu_note_text)) ?>
            </div>

        </div>
    </div>
    <script> document.addEventListener('contextmenu', function(e) { e.preventDefault(); }); </script>
</body>
</html> 