    <?php
    // This line gets the filename of the page that is currently being viewed.
    // For example, on my-account.php, this will be "my-account.php".
    $current_page = basename($_SERVER['PHP_SELF']);
    ?>

    <!-- ========== CUSTOMER ACCOUNT SIDEBAR (NAVIGATION) ========== -->
    <nav class="account-sidebar">
        <div class="sidebar-user-info">
            <div class="user-avatar"><i class="fa-solid fa-user"></i></div>
            <!-- Note: This requires the parent page to have already defined $user_name -->
            <h3><?php echo htmlspecialchars($user_name ?? 'Customer'); ?></h3>
            <p>Customer Account</p>
        </div>
        <hr>
        <ul class="account-nav-list">
            <li>
                <!-- The 'active' class is now added dynamically -->
                <a href="my-account.php" class="account-nav-link <?php echo ($current_page === 'my-account.php') ? 'active' : ''; ?>">
                    <i class="fa-solid fa-ticket"></i> My Bookings
                </a>
            </li>
            <li>
                <!-- The 'active' class is now added dynamically -->
                <a href="my-inquiries.php" class="account-nav-link <?php echo ($current_page === 'my-inquiries.php') ? 'active' : ''; ?>">
                    <i class="fa-solid fa-kaaba"></i> My Umrah Inquiries
                </a>
            </li>
            <li>
                <!-- The 'active' class is now added dynamically -->
                <a href="my-invoices.php" class="account-nav-link <?php echo ($current_page === 'my-invoices.php') ? 'active' : ''; ?>">
                    <i class="fa-solid fa-file"></i> My Invoices
                </a>
            </li>
            <li>
                <!-- The 'active' class is now added dynamically -->
                <a href="edit-profile.php" class="account-nav-link <?php echo ($current_page === 'edit-profile.php') ? 'active' : ''; ?>">
                    <i class="fa-solid fa-user-pen"></i> Edit Profile
                </a>
            </li>
            <li>
                <a href="logout.php" class="account-nav-link logout-link">
                    <i class="fa-solid fa-arrow-right-from-bracket"></i> Logout
                </a>
            </li>
        </ul>
    </nav>