<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Modern Flight Search | RF Travel & Tours</title>

  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: 'Poppins', sans-serif;
    }

    body {
      background: linear-gradient(135deg, #003366, #0066cc);
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      background-attachment: fixed;
    }

    .card {
      background: rgba(255, 255, 255, 0.15);
      backdrop-filter: blur(12px);
      border-radius: 20px;
      padding: 35px;
      width: 90%;
      max-width: 500px;
      color: #fff;
      box-shadow: 0 0 20px rgba(0,0,0,0.2);
      animation: fadeIn 1s ease;
    }

    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(20px); }
      to { opacity: 1; transform: translateY(0); }
    }

    h2 {
      text-align: center;
      margin-bottom: 25px;
      font-size: 26px;
      font-weight: 600;
      color: #fff;
      letter-spacing: 1px;
    }

    label {
      font-size: 15px;
      margin-bottom: 5px;
      display: block;
      color: #e0e0e0;
    }

    input, select {
      width: 100%;
      padding: 12px;
      border: none;
      border-radius: 8px;
      margin-bottom: 18px;
      font-size: 15px;
      outline: none;
      background: rgba(255,255,255,0.9);
      color: #333;
    }

    button {
      width: 100%;
      padding: 14px;
      font-size: 16px;
      border: none;
      border-radius: 10px;
      background: linear-gradient(135deg, #ffb347, #ffcc33);
      color: #222;
      font-weight: bold;
      cursor: pointer;
      transition: 0.3s;
    }

    button:hover {
      transform: scale(1.05);
      background: linear-gradient(135deg, #ffe259, #ffa751);
    }

    .footer {
      text-align: center;
      font-size: 13px;
      margin-top: 20px;
      color: rgba(255,255,255,0.8);
    }

    @media (max-width: 480px) {
      .card {
        padding: 25px;
      }
      h2 {
        font-size: 22px;
      }
    }
  </style>
</head>
<body>

  <div class="card">
    <h2>✈️ Search Flights</h2>

    <form action="flight-results.php" method="GET">
      <label>From City</label>
      <input type="text" name="from" placeholder="e.g. Karachi" required>

      <label>To City</label>
      <input type="text" name="to" placeholder="e.g. Dubai" required>

      <label>Departure Date</label>
      <input type="date" name="depart" required>

      <label>Return Date (Optional)</label>
      <input type="date" name="return">

      <label>Passengers</label>
      <select name="passengers">
        <option value="1">1 Adult</option>
        <option value="2">2 Adults</option>
        <option value="3">3 Adults</option>
      </select>

      <button type="submit">🔍 Search Flights</button>
    </form>

    <div class="footer">
      © <?php echo date('Y'); ?> RF Travel & Tours <br>
      Powered by Amadeus API
    </div>
  </div>

</body>
</html>
