<style>
    /* ===============================================================
   CSS for Smaller Hybrid Side Menu on Mobile
================================================================= */

@media (max-width: 768px) {
    .side-menu-container {
        /* Reduce the width of the sidebar when it's open */
        width: 200px; /* Adjust as needed */
    }

    .side-menu-container.open {
        width: 200px; /* Ensure the open width matches */
    }

    .side-menu-trigger {
        /* Adjust the trigger button position if needed */
        width: 45px;
        height: 45px;
    }

    .side-menu-nav .side-menu-item {
        /* Reduce padding for the menu items */
        padding: 10px 15px;
    }

    .side-menu-nav .side-menu-item .icon {
        /* Reduce the font size of the icons */
        font-size: 1.2rem; /* Adjust as needed */
    }

    .side-menu-nav .side-menu-item .text {
        /* Reduce the font size of the text */
        font-size: 0.9rem; /* Adjust as needed */
    }
}
</style>


<!-- =======================
Floating Action Button (FAB) Start
======================== -->
<div class="floating-action-button" id="fab-container">
    <!-- The main button that is always visible -->
    <button class="fab-main" id="fab-main-btn" aria-label="Open contact options">
        <i class="fa-solid fa-headset"></i>
    </button>
    <!-- The menu that is hidden by default -->
    <div class="fab-menu">
        <a href="https://wa.me/923052394810" target="_blank" class="fab-item" aria-label="Contact on WhatsApp">
            <i class="fa-brands fa-whatsapp"></i>
        </a>
        <a href="tel:923052394810" class="fab-item" aria-label="Call Us">
            <i class="fa-solid fa-phone"></i>
        </a>
        <a href="mailto:rftravelsandtours@gmail.com" class="fab-item" aria-label="Email Us">
            <i class="fa-solid fa-envelope"></i>
        </a>
    </div>
</div>
<!-- =======================
Floating Action Button (FAB) End
======================== -->



<!-- ===============================================================
         HTML for the Hybrid Side Menu
    ================================================================= -->

<div class="side-menu-container" id="side-menu">
    <!-- The trigger button -->
    <button class="side-menu-trigger" id="side-menu-trigger-btn" aria-label="Open side menu">
        <span class="icon"><i class="fa-solid fa-chevron-left"></i></span>
    </button>

    <!-- The navigation menu -->
    <nav class="side-menu-nav">

        <a href="packages-rate-list.php" target="_blank" rel="noopener noreferrer" class="side-menu-item">
            <span class="icon"><i class="fa-solid fa-kaaba"></i></span>
            <span class="text">View Packages</span>
        </a>

        <a href="hotel-rates.php" target="_blank" rel="noopener noreferrer" class="side-menu-item">
            <span class="icon"><i class="fa-solid fa-star"></i></span>
            <span class="text">Star Hotels</span>
        </a>

        <a href="transport-rates.php" target="_blank" rel="noopener noreferrer" class="side-menu-item">
            <span class="icon"><i class="fa-solid fa-car"></i></span>
            <span class="text">Transport Rates</span>
        </a>

    </nav>
</div>

<!-- ======================= End of Menu Block ========================= -->

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const sideMenu = document.getElementById('side-menu');
        const menuTrigger = document.getElementById('side-menu-trigger-btn');

        const isTouchDevice = ('ontouchstart' in window) || (navigator.maxTouchPoints > 0);

        if (isTouchDevice && sideMenu && menuTrigger) {
            sideMenu.classList.add('js-touched');

            // Setup Click-to-Toggle
            menuTrigger.addEventListener('click', function(event) {
                // *** THIS IS THE FIX ***
                // Stop the click from bubbling up to the document.
                // This prevents the 'click-away' listener from immediately closing the menu.
                event.stopPropagation();

                sideMenu.classList.toggle('open');
            });

            // Setup Click-Away-to-Close
            document.addEventListener('click', function(event) {
                // If the menu is open AND the click was outside the menu, close it.
                if (sideMenu.classList.contains('open') && !sideMenu.contains(event.target)) {
                    sideMenu.classList.remove('open');
                }
            });
        }
        // On non-touch devices, no JavaScript is needed for the hover effect.
    });
</script>

<!-- =======================
Back to Top Button Start
======================== -->
<a href="#" class="back-to-top" id="back-to-top-btn" aria-label="Go back to top of page">
    <i class="fa-solid fa-arrow-up"></i>
</a>
<!-- =======================
Back to Top Button End
======================== -->