<!-- ============================================= -->
<!-- ===== SITE FOOTER SECTION ===== -->
<!-- ============================================= -->
<footer class="site-footer">
    <div class="footer-container">
        <div class="footer-main">

            <!-- Column 1: About -->
            <div class="footer-col">
                <div class="footer-logo-text">
                    <img src="images/logo-2.png" alt="RF Travel & Tours Logo" style="height: 60px; width: auto;">
                </div>

                <style>
                    .footer-logo-text {
                        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                        /* clean modern font */
                        font-size: 28px;
                        /* larger size */
                        font-weight: bold;
                        color: white;
                        /* white text for footer */
                    }
                </style>


                <p class="footer-about-text">
                    Your trusted partner in creating memorable travel experiences. From spiritual journeys to thrilling adventures, we are dedicated to delivering excellence every step of the way.
                </p>
            </div>

            <!-- Column 2: Quick Links -->
            <div class="footer-col">
                <h4>Quick Links</h4>
                <ul>
                    <li><a href="/">Flights</a></li>
                    <li><a href="/hotels.php">Hotels</a></li>
                    <li><a href="#">Domestic Tours</a></li>
                    <li><a href="#">International Tours</a></li>
                    <li><a href="#">Umrah Packages</a></li>
                    <li><a href="#">Visa Services</a></li>
                </ul>
            </div>

            <!-- Column 3: Support -->
            <div class="footer-col">
                <h4>Support</h4>
                <ul>
                    <li><a href="about-us.php">About Us</a></li>
                    <li><a href="contact-us.php">Contact Us</a></li>
                    <li><a href="faq.php">FAQs</a></li>
                    <li><a href="privacy-policy.php">Privacy Policy</a></li>
                    <li><a href="terms-and-conditions.php">Terms & Conditions</a></li>
                </ul>
            </div>

            <!-- Column 4: Contact -->
            <div class="footer-col">
                <h4>Contact Us</h4>
                <div class="contact-item">
                    <i class="fa-solid fa-location-dot"></i>
                    <span>AL Quresh Near Railway Pahatak,  Infront of Al Quresh Housing Scheme Sher Shah Road Multan</span>
                </div>
                <div class="contact-item">
                    <i class="fa-solid fa-phone"></i>
                    <span>0305 2394810</span>
                </div>
                <div class="contact-item">
                    <i class="fa-solid fa-envelope"></i>
                    <span>rftravelsandtours@gmail.com</span>
                </div>
                <div class="social-links">
                    <a href="#"
                        aria-label="Facebook" target="_blank" rel="noopener noreferrer">
                        <i class="fab fa-facebook-f"></i>
                    </a>

                    <a href="#"
                        aria-label="Instagram" target="_blank" rel="noopener noreferrer">
                        <i class="fab fa-instagram"></i>
                    </a>

                    <a href="#" aria-label="Twitter" target="_blank" rel="noopener noreferrer">
                        <i class="fab fa-twitter"></i>
                    </a>

                    <a href="https://wa.me/923052394810"
                        aria-label="WhatsApp" target="_blank" rel="noopener noreferrer">
                        <i class="fab fa-whatsapp"></i>
                    </a>
                </div>

            </div>

        </div>
        <div class="footer-bottom">
            <!-- The year is now wrapped in a span with an ID -->
            <p class="copyright-text">
                © <span id="copyright-year"><?php echo date('Y'); ?></span> RF Travel & Tours All Rights Reserved.
            </p>
        </div>
    </div>
</footer>



<script>
    // =======================================================
    // NEW BACK TO TOP BUTTON SCRIPT
    // =======================================================
    const backToTopBtn = document.getElementById('back-to-top-btn');

    window.addEventListener('scroll', () => {
        // If scrolled more than 300 pixels down, show the button
        if (window.scrollY > 300) {
            backToTopBtn.classList.add('visible');
        } else {
            backToTopBtn.classList.remove('visible');
        }
    });

    // Smooth scroll to top when clicked
    backToTopBtn.addEventListener('click', (e) => {
        e.preventDefault(); // Prevent the default jump-to-top behavior
        window.scrollTo({
            top: 0,
            behavior: 'smooth' // This creates the smooth scrolling animation
        });
    });
    // =======================================================
    // END OF BACK TO TOP SCRIPT
    // =======================================================




    const fabContainer = document.getElementById('fab-container');
    const fabMainBtn = document.getElementById('fab-main-btn');

    fabMainBtn.addEventListener('click', () => {
        fabContainer.classList.toggle('open');
    });

    // Optional: Close the menu if the user clicks outside of it
    document.addEventListener('click', function(event) {
        if (!fabContainer.contains(event.target)) {
            fabContainer.classList.remove('open');
        }
    });

    document.addEventListener('DOMContentLoaded', (event) => {
        document.getElementById("copyright-year").textContent = new Date().getFullYear();
    });















    document.addEventListener('DOMContentLoaded', function() {
        const menuToggle = document.querySelector('.menu-toggle');
        const sidebarCloseBtn = document.querySelector('.sidebar-close-btn');
        const sidebar = document.querySelector('.mobile-sidebar');
        const sidebarOverlay = document.querySelector('.sidebar-overlay');

        function openSidebar() {
            sidebar.classList.add('is-open');
            sidebarOverlay.classList.add('is-visible');
            document.body.style.overflow = 'hidden'; // Prevent background scroll
        }

        function closeSidebar() {
            sidebar.classList.remove('is-open');
            sidebarOverlay.classList.remove('is-visible');
            document.body.style.overflow = ''; // Restore background scroll
        }

        if (menuToggle) {
            menuToggle.addEventListener('click', openSidebar);
        }
        if (sidebarCloseBtn) {
            sidebarCloseBtn.addEventListener('click', closeSidebar);
        }
        if (sidebarOverlay) {
            sidebarOverlay.addEventListener('click', closeSidebar);
        }
    });
</script>