<?php
// This script acts as a proxy to fetch images from external URLs, bypassing browser CORS restrictions.

// Set a generous timeout limit for fetching remote images
set_time_limit(60);

// Check if a URL is provided
if (!isset($_GET['url']) || empty($_GET['url'])) {
    http_response_code(400);
    die('Error: No image URL specified.');
}

$imageUrl = filter_var($_GET['url'], FILTER_VALIDATE_URL);

if ($imageUrl === false) {
    http_response_code(400);
    die('Error: Invalid URL format.');
}

// Use cURL for robust fetching
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $imageUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); // Follow redirects
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36'); // Mimic a browser

$imageData = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$contentType = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);

curl_close($ch);

// Check for successful fetch and valid image content type
if ($httpCode == 200 && strpos($contentType, 'image/') === 0) {
    // Crucially, tell the browser it can use this image from any origin
    header('Access-Control-Allow-Origin: *');
    header('Content-Type: ' . $contentType);
    echo $imageData;
} else {
    // If it fails, send an error status
    http_response_code(404);
    die('Error: Image not found or could not be loaded.');
}

exit;