<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once 'db-config.php';


$umrah_packages_grid_result = null;
try {
    $sql = "SELECT up.*, a.airline_name, a.logo_url 
            FROM umrah_packages up
            LEFT JOIN airlines a ON up.airline_id = a.id
            WHERE up.is_active = 1 
            ORDER BY up.last_updated DESC 
            LIMIT 3";
    $umrah_packages_grid_result = $conn->query($sql);
} catch (Exception $e) {
    error_log("Failed to fetch Umrah packages for homepage grid: " . $e->getMessage());
}

// Check for service redirect parameter
$service_redirect = isset($_GET['service_redirect']) ? htmlspecialchars($_GET['service_redirect']) : '';

?>

<!DOCTYPE html>

<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RF Travel & Tours - Your Trusted Company for Travel Services</title>
    <link rel="icon" type="image/png" href="images/logo-icon.png">
    <link rel="stylesheet" href="css/style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    
    <style>
        .hero-section {
            padding-bottom: 120px;
        }

        .search-form-wrapper, .form-grid, .form-field {
            overflow: visible !important;
        }
        .form-field.active {
            z-index: 10;
        }
        .dropdown-menu {
            z-index: 100;
        }

        .btn-show-fare:disabled {
            background-color: #ccc;
            cursor: not-allowed;
            opacity: 0.7;
        }

        .passenger-limit-warning {
            display: none; font-size: 13px; color: #d9534f; font-weight: 500; padding: 10px;
            background-color: #f8d7da; border-radius: 4px; margin-top: 10px; text-align: center;
        }

        .trip-type { display: flex; gap: 10px; margin-bottom: 15px; }
        .trip-type input[type="radio"] { display: none; }
        .trip-type .trip-label { padding: 6px 15px; border: 1px solid #ccc; border-radius: 20px; cursor: pointer; font-size: 14px; background: #f9f9f9; transition: all 0.3s ease; }
        .trip-type input[type="radio"]:checked+.trip-label { background: #12a7ee; color: #fff; border-color: #12a7ee; }
        
        #return-date-field { display: none; }

        #multiCityContainer .trip-form { position: relative; margin-top: 15px; border-top: 1px dashed #ccc; padding-top: 15px; padding-right: 120px; }
        .remove-trip-btn { position: absolute; right: 0; top: 50%; transform: translateY(-50%); padding: 8px 18px; background: #e63946; color: #fff; border: none; border-radius: 20px; font-size: 13px; cursor: pointer; font-weight: 500; }
        
        .traveler-field .traveler-dropdown { right: 0; left: auto; width: 340px; }
        .traveler-dropdown .class-selection { display: grid; grid-template-columns: repeat(2, auto); justify-content: start; gap: 10px 20px; }
        .traveler-dropdown .class-selection label { display: flex; align-items: center; cursor: pointer; font-size: 14px; margin: 0; white-space: nowrap; }
        .traveler-dropdown .class-selection input[type="radio"] { margin-right: 8px; }

        .form-field .flatpickr-calendar { top: 100% !important; left: 0 !important; }
        .flatpickr-calendar { z-index: 1050; }

        @media (max-width: 768px) {
            .hero-section {
                height: auto !important; min-height: unset !important; padding: 0 1rem 1rem 1rem !important;
                display: block !important; margin-bottom: 200px !important; 
            }
            .hero-content {
                padding-top: 80px !important; text-align: center; margin-bottom: -7rem;
            }
            .search-container {
                position: relative !important; top: auto !important; left: auto !important;
                transform: none !important; width: 100% !important; margin-top: 0 !important;
            }
            .search-form-wrapper { background: #fff; border-radius: 12px; padding: 1rem; box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1); }
            .form-grid.trip-form { display: flex; flex-direction: column; gap: 0; }
            .form-field { padding: 12px 10px; border-bottom: 1px solid #f0f0f0; display: flex; flex-direction: column; align-items: flex-start; }
            .form-field:last-child { border-bottom: none; }
            .form-field label { font-size: 11px; text-transform: uppercase; color: #888; margin-bottom: 4px; font-weight: 500; }
            .form-field .value-main { font-size: 16px; }
            .form-field .value-sub { font-size: 12px; color: #777; font-weight: 400; }
            .swap-icon-container { position: absolute; top: 80px; right: 15px; z-index: 5; transform: rotate(90deg); width: 36px; height: 36px; background: #fff; border: 1px solid #ddd; border-radius: 50%; display: flex; align-items: center; justify-content: center; cursor: pointer; }
            .swap-icon { font-size: 14px; }
            #multiCityContainer .trip-form { padding-right: 0; }
            .remove-trip-btn { position: relative; transform: none; top: auto; right: auto; width: 150px; margin: 10px auto 0; display: block; }
            .submit-button-container { margin-top: 1.5rem; }
            .btn-show-fare { width: 100%; font-size: 18px; font-weight: 600; padding: 15px; }
            .trip-type { flex-wrap: wrap; }
            
            /* --- CSS FIX FOR DROPDOWN POSITIONING ON MOBILE --- */
            .form-field .dropdown-menu {
                position: absolute;
                top: 100%;
                left: 0;
                right: 0;
                width: auto;
            }
            /* --- END FIX --- */

            .traveler-dropdown .class-selection { display: flex; flex-direction: column; align-items: flex-start; gap: 15px; }
        }
    </style>
</head>

<body>
    <?php include 'header.php'; ?>

    <main>
        <section class="hero-section">
            <div class="hero-content">
                <h1>Discover the World <br> and Its Wonders</h1>
                <p>Embark on journeys that inspire the soul and create unforgettable memories beyond imagination.</p>
            </div>
            <div class="search-container">
                <div class="tabs-wrapper">
                    <div class="service-tabs">
                        <a href="index.php" class="tab active"><i class="fa-solid fa-plane-up"></i> Ticket</a>
                    <a href="group-fares.php" class="tab"><i class="fa-solid fa-users"></i> Groups</a>
                    <a href="umrah-packages.php" class="tab"><i class="fa-solid fa-kaaba"></i> Umrah</a>
                    <a href="hotels.php" class="tab"><i class="fa-solid fa-hotel"></i> Hotels</a>
                    <a href="visa-services.php" class="tab"><i class="fa-solid fa-passport"></i> Visas</a>
                    <a href="custom-package.php" class="tab"><i class="fa-solid fa-kaaba"></i> Custom Package</a>
                    </div>
                </div>
                <div class="search-form-wrapper">
                    <div class="trip-type">
                        <input type="radio" id="one-way" name="trip-type" value="one-way" checked>
                        <label for="one-way" class="trip-label"><h5>One Way</h5></label>
                        <input type="radio" id="return" name="trip-type" value="return">
                        <label for="return" class="trip-label"><h5>Return</h5></label>
                        <input type="radio" id="multi-city" name="trip-type" value="multi-city">
                        <label for="multi-city" class="trip-label"><h5>Multi-City</h5></label>
                    </div>
                    <form class="flight-search-form" id="flight-search-form">
                        <!-- Hidden input for service redirection -->
                        <input type="hidden" name="service_redirect" value="<?php echo $service_redirect; ?>">
                        
                        <div class="form-grid trip-form">
                            <div class="form-field from-field dropdown-toggle">
                                <label><i class="fa fa-map-marker-alt"></i> FROM</label>
                                <div class="value-main" data-value-code="KHI">Karachi</div>
                                <div class="value-sub">Pakistan- Jinnah International</div>
                                <div class="dropdown-menu location-dropdown">
                                    <div class="dropdown-header"><input type="text" placeholder="Search for a city or airport"></div>
                                    <ul><li>Type to search...</li></ul>
                                </div>
                            </div>
                            
                            <div class="swap-icon-container"><div class="swap-icon"><i class="fa-solid fa-right-left"></i></div></div>

                            <div class="form-field to-field dropdown-toggle">
                                <label><i class="fa fa-map-marker-alt"></i> TO</label>
                                <div class="value-main" data-value-code="ISB">Islamabad</div>
                                <div class="value-sub">Pakistan- Islamabad International</div>
                                <div class="dropdown-menu location-dropdown">
                                    <div class="dropdown-header"><input type="text" placeholder="Search for a city or airport"></div>
                                    <ul><li>Type to search...</li></ul>
                                </div>
                            </div>

                            <div class="form-field date-field" id="journey-date-field"><label><i class="fa fa-calendar"></i> JOURNEY DATE</label><input type="hidden" class="journey-date-input" id="journey-date-input"><div class="value-main">Select A Date</div></div>
                            <div class="form-field date-field" id="return-date-field"><label><i class="fa fa-calendar"></i> RETURN DATE</label><input type="hidden" class="return-date-input" id="return-date-input"><div class="value-main placeholder">Tap to add a return date</div></div>
                            
                            <div class="form-field traveler-field dropdown-toggle"><label>TRAVELER & CLASS</label><div class="value-main">1 Traveller</div><div class="value-sub">Economy</div><div class="dropdown-menu traveler-dropdown"><div class="passenger-row"><span>Adults <small>(12+ years)</small></span><div class="passenger-counter"><button type="button" class="counter-btn" data-type="adults" data-action="decrement">-</button><span class="pax-count-adults">1</span><button type="button" class="counter-btn" data-type="adults" data-action="increment">+</button></div></div><div class="passenger-row"><span>Children <small>(2-11 years)</small></span><div class="passenger-counter"><button type="button" class="counter-btn" data-type="children" data-action="decrement">-</button><span class="pax-count-children">0</span><button type="button" class="counter-btn" data-type="children" data-action="increment">+</button></div></div><div class="passenger-row"><span>Infants <small>(under 2 years)</small></span><div class="passenger-counter"><button type="button" class="counter-btn" data-type="infants" data-action="decrement">-</button><span class="pax-count-infants">0</span><button type="button" class="counter-btn" data-type="infants" data-action="increment">+</button></div></div><div class="passenger-limit-warning">Maximum of 9 travellers reached.</div><hr><div class="class-selection"><label><input type="radio" name="flight-class" value="Economy" checked> Economy</label><label><input type="radio" name="flight-class" value="Premium Economy"> Premium Economy</label><label><input type="radio" name="flight-class" value="Business"> Business</label></div><div class="dropdown-footer"><button type="button" class="btn-done">Done</button></div></div></div>
                        </div>
                        <div id="multiCityContainer"></div>
                        <button type="button" id="addTripBtn" style="display:none;margin-top:15px;padding:10px 20px;background:#12a7ee;color:#fff;border:none;border-radius:25px;font-size:14px;font-weight:600;cursor:pointer;box-shadow:0 3px 6px rgba(0,0,0,0.15);transition:0.3s ease;">+ Add Another Trip</button>
                        <div class="submit-button-container"><button type="submit" class="btn-show-fare" disabled>Show Fare</button></div>
                    </form>
                </div>
            </div>
        </section>

        <?php include 'umrah-package-listings.php'; ?>
        <?php include 'visa-services-listings.php'; ?>
        <?php include 'hotel-listings-section.php'; ?>
        <?php include 'airline-logos.php'; ?>
        <?php include 'promo-cards.php'; ?>
        <?php include 'floating-icon.php'; ?>
        <?php include 'footer.php'; ?>
    </main>

    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const AMADEUS_API_KEY = 'ODHfAdal8JCJrcFC8NGrbSnAVmCS3hMC';
            const AMADEUS_API_SECRET = '2VHNu0uaCSiGDsT4';
            let amadeusAccessToken = null;

            async function getAmadeusToken() { if (amadeusAccessToken) return amadeusAccessToken; try { const response = await fetch('https://api.amadeus.com/v1/security/oauth2/token', { method: 'POST', headers: { 'Content-Type': 'application/x-www-form-urlencoded' }, body: `grant_type=client_credentials&client_id=${AMADEUS_API_KEY}&client_secret=${AMADEUS_API_SECRET}` }); if (!response.ok) throw new Error('Token fetch failed'); const data = await response.json(); amadeusAccessToken = data.access_token; return amadeusAccessToken; } catch (error) { console.error("Amadeus Auth Error:", error); return null; } }
            
            const debounce = (func, delay) => { let timeout; return (...args) => { clearTimeout(timeout); timeout = setTimeout(() => func(...args), delay); }; };
            
            const handleLocationSearch = debounce(async (inputElement, resultsList) => {
                const keyword = inputElement.value;
                if (keyword.length < 2) { resultsList.innerHTML = '<li>Type to search...</li>'; return; }
                resultsList.innerHTML = '<li class="loading-item">Loading...</li>';
                const locations = await searchLocations(keyword);
                
                const sortedLocations = [...locations].sort((a, b) => {
                    const keywordLower = keyword.toLowerCase();
                    const aMatch = a.iataCode.toLowerCase() === keywordLower;
                    const bMatch = b.iataCode.toLowerCase() === keywordLower;
                    if (aMatch && !bMatch) return -1;
                    if (!aMatch && bMatch) return 1;
                    return 0;
                });

                resultsList.innerHTML = '';
                if (sortedLocations.length > 0) {
                    sortedLocations.forEach(location => {
                        const li = document.createElement('li');
                        li.dataset.code = location.iataCode; li.dataset.city = location.address.cityName; li.dataset.country = location.address.countryName; li.dataset.name = location.name;
                        li.innerHTML = `<strong>${location.address.cityName}</strong>, ${location.address.countryName} <span class="iata-code">${location.iataCode}</span>`;
                        resultsList.appendChild(li);
                    });
                } else { resultsList.innerHTML = '<li class="no-results-item">No results found</li>'; }
            }, 350);
            
            async function searchLocations(keyword) {
                 const token = await getAmadeusToken();
                 if (!token) return [];
                 const url = `https://api.amadeus.com/v1/reference-data/locations?subType=CITY,AIRPORT&keyword=${keyword}&view=LIGHT`;
                 try {
                     const response = await fetch(url, { headers: { 'Authorization': `Bearer ${token}` } });
                     if (!response.ok) throw new Error('Location fetch failed');
                     const data = await response.json();
                     return data.data || [];
                 } catch (error) {
                     console.error("Amadeus Search Error:", error);
                     return [];
                 }
            }

            const mainForm = document.getElementById('flight-search-form');
            const submitButton = document.querySelector('.btn-show-fare');

            const closeAllPopups = () => {
                document.querySelectorAll('.form-field.active').forEach(field => field.classList.remove('active'));
                if(window.journeyDatepicker && window.journeyDatepicker.isOpen) window.journeyDatepicker.close();
                if(window.returnDatepicker && window.returnDatepicker.isOpen) window.returnDatepicker.close();
            };
            
            const isSegmentValid = (segment) => {
                const originCode = segment.querySelector('.from-field .value-main').dataset.valueCode;
                const destCode = segment.querySelector('.to-field .value-main').dataset.valueCode;
                const dateValue = segment.querySelector('.journey-date-input').value;
                return originCode && destCode && dateValue;
            };

            const updateSubmitButtonState = () => {
                const tripType = document.querySelector("input[name='trip-type']:checked").value;
                let allValid = true;

                if (tripType === 'one-way') {
                    allValid = isSegmentValid(mainForm.querySelector('.trip-form'));
                } else if (tripType === 'return') {
                    const mainSegmentValid = isSegmentValid(mainForm.querySelector('.trip-form'));
                    const returnDateFilled = document.getElementById('return-date-input').value;
                    allValid = mainSegmentValid && !!returnDateFilled;
                } else if (tripType === 'multi-city') {
                    const allSegments = mainForm.querySelectorAll('.trip-form');
                    if (allSegments.length < 2) allValid = false;
                    allSegments.forEach(segment => {
                        if (!isSegmentValid(segment)) allValid = false;
                    });
                }
                submitButton.disabled = !allValid;
            };
            
            function setupFormSegment(segment) {
                segment.querySelectorAll('.dropdown-toggle').forEach(toggle => {
                    toggle.addEventListener('click', (e) => {
                        e.stopPropagation();
                        const currentlyActive = document.querySelector('.form-field.active');
                        if (currentlyActive && currentlyActive !== toggle) {
                            currentlyActive.classList.remove('active');
                        }
                        toggle.classList.toggle('active');
                        if (toggle.classList.contains('active')) {
                            const searchInput = toggle.querySelector('.location-dropdown input');
                            if (searchInput) setTimeout(() => searchInput.focus(), 50);
                        }
                    });
                });

                segment.querySelectorAll('.dropdown-menu').forEach(menu => menu.addEventListener('click', e => e.stopPropagation()));

                segment.querySelectorAll('.location-dropdown ul').forEach(list => {
                    list.addEventListener('click', (event) => {
                        const li = event.target.closest('li');
                        if (li && li.dataset.code) {
                            const formField = li.closest('.form-field');
                            formField.querySelector('.value-main').textContent = li.dataset.city;
                            formField.querySelector('.value-main').dataset.valueCode = li.dataset.code;
                            formField.querySelector('.value-sub').textContent = `${li.dataset.country} - ${li.dataset.name}`;
                            closeAllPopups();
                            updateSubmitButtonState();
                        }
                    });
                });
                segment.querySelectorAll('.location-dropdown input[type="text"]').forEach(input => {
                    input.addEventListener('input', () => handleLocationSearch(input, input.closest('.location-dropdown').querySelector('ul')));
                    input.addEventListener('keydown', (e) => {
                        if (e.key === 'Enter') {
                            e.preventDefault();
                            const firstResult = input.closest('.location-dropdown').querySelector('ul li:not(.loading-item):not(.no-results-item)');
                            if (firstResult) firstResult.click();
                        }
                    });
                });

                const travelerField = segment.querySelector('.traveler-field');
                if (travelerField) {
                    const warning = travelerField.querySelector('.passenger-limit-warning');
                    const updateTotalDisplay = () => {
                        const adults = parseInt(travelerField.querySelector('.pax-count-adults').textContent);
                        const children = parseInt(travelerField.querySelector('.pax-count-children').textContent);
                        const infants = parseInt(travelerField.querySelector('.pax-count-infants').textContent);
                        travelerField.querySelector('.value-main').textContent = `${adults + children + infants} Traveller${(adults + children + infants) > 1 ? 's' : ''}`;
                        travelerField.querySelector('.value-sub').textContent = travelerField.querySelector('input[name="flight-class"]:checked').value;
                        const incrementButtons = travelerField.querySelectorAll('[data-action="increment"]');
                        if (adults + children >= 9) {
                            incrementButtons.forEach(btn => { if (btn.dataset.type !== 'infants') btn.disabled = true; });
                            warning.style.display = 'block';
                        } else {
                            incrementButtons.forEach(btn => btn.disabled = false);
                            warning.style.display = 'none';
                        }
                        travelerField.querySelector('.counter-btn[data-type="infants"][data-action="increment"]').disabled = (infants >= adults);
                    };
                    travelerField.querySelectorAll('.counter-btn').forEach(btn => btn.addEventListener('click', (e) => { e.stopPropagation(); const countSpan = btn.parentElement.querySelector('span'); let count = parseInt(countSpan.textContent); if (btn.dataset.action === 'increment') count++; else if (count > (btn.dataset.type === 'adults' ? 1 : 0)) count--; countSpan.textContent = count; updateTotalDisplay(); }));
                    travelerField.querySelectorAll('input[name="flight-class"]').forEach(radio => radio.addEventListener('change', updateTotalDisplay));
                    travelerField.querySelector('.btn-done').addEventListener('click', (e) => { e.stopPropagation(); closeAllPopups(); });
                    updateTotalDisplay();
                }

                segment.querySelectorAll('.date-field').forEach(field => {
                    const input = field.querySelector('input[type="hidden"]');
                    if (!input || field._flatpickr) return;
                    const picker = flatpickr(input, { appendTo: field, clickOpens: false, disableMobile: true, minDate: "today",
                        onChange: (selectedDates) => {
                            if (selectedDates.length > 0) {
                                const d = selectedDates[0];
                                field.querySelector('.value-main').textContent = `${d.getDate()} ${d.toLocaleString('default', { month: 'short' })} ${d.getFullYear()}`;
                                field.querySelector('.value-main').classList.remove('placeholder');
                                if (field.id === 'journey-date-field') {
                                    const returnPicker = document.getElementById('return-date-field')._flatpickr;
                                    if (returnPicker) returnPicker.set('minDate', d);
                                }
                            }
                            updateSubmitButtonState();
                        }
                    });
                    field._flatpickr = picker;
                    field.addEventListener('click', e => { e.stopPropagation(); closeAllPopups(); field._flatpickr.open(); });
                });
            }

            document.addEventListener('click', closeAllPopups);
            
            const futureDate = new Date();
            futureDate.setDate(futureDate.getDate() + 2);
            mainForm.querySelector('#journey-date-field .value-main').textContent = `${futureDate.getDate()} ${futureDate.toLocaleString('default', { month: 'short' })} ${futureDate.getFullYear()}`;
            document.getElementById('journey-date-input').value = `${futureDate.getFullYear()}-${String(futureDate.getMonth() + 1).padStart(2, '0')}-${String(futureDate.getDate()).padStart(2, '0')}`;
            
            setupFormSegment(mainForm);
            
            window.journeyDatepicker = document.getElementById('journey-date-field')._flatpickr;
            window.returnDatepicker = document.getElementById('return-date-field')._flatpickr;

            mainForm.querySelector('.swap-icon-container').addEventListener('click', (e) => { e.stopPropagation(); const fromField = mainForm.querySelector('.from-field'), toField = mainForm.querySelector('.to-field'); const fromMain = fromField.querySelector('.value-main'), fromSub = fromField.querySelector('.value-sub'); const toMain = toField.querySelector('.value-main'), toSub = toField.querySelector('.value-sub'); const temp = { main: fromMain.textContent, sub: fromSub.textContent, code: fromMain.dataset.valueCode }; fromMain.textContent = toMain.textContent; fromSub.textContent = toSub.textContent; fromMain.dataset.valueCode = toMain.dataset.valueCode; toMain.textContent = temp.main; toSub.textContent = temp.sub; toMain.dataset.valueCode = temp.code; });

            const tripOptions = document.querySelectorAll("input[name='trip-type']");
            const returnDateField = document.getElementById("return-date-field");
            const addTripBtn = document.getElementById("addTripBtn");
            const multiCityContainer = document.getElementById("multiCityContainer");
            let tripCount = 0;
            
            const updateFormLayout = (tripType) => { 
                returnDateField.style.display = (tripType === "return") ? "block" : "none"; 
                addTripBtn.style.display = (tripType === "multi-city") ? "inline-block" : "none"; 
                if (tripType !== "multi-city") { multiCityContainer.innerHTML = ""; tripCount = 0; } 
                else if (multiCityContainer.children.length === 0) { addTripBtn.click(); } 
                updateSubmitButtonState();
            };
            tripOptions.forEach(option => option.addEventListener("change", (e) => { updateFormLayout(e.target.value); }));
            
            addTripBtn.addEventListener("click", () => { 
                tripCount++; 
                const newFormHtml = `<div class="form-grid trip-form" id="trip-form-${tripCount}"><div class="form-field from-field dropdown-toggle"><label><i class="fa fa-map-marker-alt"></i> FROM</label><div class="value-main" data-value-code="">Select Origin</div><div class="value-sub"></div><div class="dropdown-menu location-dropdown"><div class="dropdown-header"><input type="text" placeholder="Search..."></div><ul><li>Type to search...</li></ul></div></div><div class="form-field to-field dropdown-toggle"><label><i class="fa fa-map-marker-alt"></i> TO</label><div class="value-main" data-value-code="">Select Destination</div><div class="value-sub"></div><div class="dropdown-menu location-dropdown"><div class="dropdown-header"><input type="text" placeholder="Search..."></div><ul><li>Type to search...</li></ul></div></div><div class="form-field date-field"><label><i class="fa fa-calendar"></i> JOURNEY DATE</label><input type="hidden" class="journey-date-input"><div class="value-main">Select A Date</div></div><button type="button" class="remove-trip-btn">Remove Trip</button></div>`;
                const newFormContainer = document.createElement('div');
                newFormContainer.innerHTML = newFormHtml;
                const newTripForm = newFormContainer.firstElementChild;
                newTripForm.querySelector('.remove-trip-btn').addEventListener("click", () => { newTripForm.remove(); updateSubmitButtonState(); }); 
                multiCityContainer.appendChild(newTripForm);
                setupFormSegment(newTripForm);
                updateSubmitButtonState();
            });
            
            updateFormLayout(document.querySelector("input[name='trip-type']:checked").value);
            
            mainForm.addEventListener('submit', (event) => { 
                event.preventDefault();
                const params = new URLSearchParams(); 
                const tripType = document.querySelector('input[name="trip-type"]:checked').value; 
                params.append('tripType', tripType); 
                
                const serviceRedirectInput = mainForm.querySelector('input[name="service_redirect"]');
                if (serviceRedirectInput && serviceRedirectInput.value) {
                    params.append('service_redirect', serviceRedirectInput.value);
                }

                const travelerField = mainForm.querySelector('.traveler-field'); 
                params.append('adults', travelerField.querySelector('.pax-count-adults').textContent); 
                params.append('children', travelerField.querySelector('.pax-count-children').textContent); 
                params.append('infants', travelerField.querySelector('.pax-count-infants').textContent); 
                params.append('travelClass', travelerField.querySelector('input[name="flight-class"]:checked').value); 
                
                mainForm.querySelectorAll('.trip-form').forEach((trip, index) => {
                    params.append(`legs[${index}][origin]`, trip.querySelector('.from-field .value-main').dataset.valueCode);
                    params.append(`legs[${index}][destination]`, trip.querySelector('.to-field .value-main').dataset.valueCode);
                    params.append(`legs[${index}][date]`, trip.querySelector('.journey-date-input').value);
                });
                
                if (tripType === 'return') { 
                    const returnDateValue = mainForm.querySelector('#return-date-input').value; 
                    if (returnDateValue) { params.append('returnDate', returnDateValue); } 
                }

                const redirectUrl = `flight-search.php?${params.toString()}`; 
                window.location.href = redirectUrl; 
            });
        });
    </script>
</body>
</html>