<?php
session_start();
require_once 'db-config.php';
require_once 'vendor/autoload.php'; // Required to load the Stripe library

// --- SECURITY CHECKS ---
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['flight_data'])) {
    header("Location: index.php");
    exit;
}

// --- CONFIGURE STRIPE ---
// IMPORTANT: Replace with your ACTUAL Stripe secret key from your dashboard.
\Stripe\Stripe::setApiKey('sk_test_YOUR_SECRET_KEY_HERE'); 

// IMPORTANT: Set this to your website's domain.
$YOUR_DOMAIN = 'http://localhost/rf'; // For local WAMP server
// For live server: $YOUR_DOMAIN = 'https://demo.rftravelandtours.com';

// --- GATHER DATA FROM CHECKOUT FORM ---
$flight_data = json_decode($_POST['flight_data'], true);
$passenger_data = $_POST['passengers'] ?? []; // The detailed passenger array
$contact_details = $_POST['contact_details'] ?? [];

// Store all necessary data in the session
$_SESSION['pending_booking_data'] = [
    'flight_details' => json_encode($flight_data),
    'passenger_details' => json_encode($passenger_data),
    'contact_details' => json_encode($contact_details)
];

$total_price_pkr = (float)($flight_data['price'] ?? 0);
$price_in_paisa = round($total_price_pkr * 100);

try {
    $checkout_session = \Stripe\Checkout\Session::create([
        'payment_method_types' => ['card'],
        'line_items' => [[
            'price_data' => [
                'currency' => 'pkr',
                'unit_amount' => $price_in_paisa,
                'product_data' => [
                    'name' => 'Flight Booking: ' . ($flight_data['itineraries'][0]['origin'] ?? 'N/A') . ' to ' . ($flight_data['itineraries'][0]['destination'] ?? 'N/A'),
                    'description' => 'Payment for flight booking with RF Travel & Tours.',
                ],
            ],
            'quantity' => 1,
        ]],
        'mode' => 'payment',
        'success_url' => $YOUR_DOMAIN . '/success.php?session_id={CHECKOUT_SESSION_ID}',
        'cancel_url' => $YOUR_DOMAIN . '/cancel.php',
    ]);

    header("HTTP/1.1 303 See Other");
    header("Location: " . $checkout_session->url);
    exit;

} catch (Exception $e) {
    $_SESSION['checkout_error'] = "Could not connect to payment gateway. Please try again. Error: " . $e->getMessage();
    // Redirect back to the original checkout URL
    $flight_id_for_redirect = $_GET['flight_id'] ?? array_search($flight_data, $_SESSION['flight_search_results']);
    header("Location: checkout.php?flight_id=" . $flight_id_for_redirect);
    exit;
}