<?php
// We need to start the session to show the correct header state (logged in/out)
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
?>
<!DOCTYPE html>
<html>

<head>
    <title>Privacy Policy - RF Travel & Tours</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Main Stylesheet (for variables) -->
    <link rel="stylesheet" href="css/style.css">
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css">
    <!-- NEW dedicated stylesheet for this page -->
    <link rel="stylesheet" href="css/policy-style.css">
</head>

<body>

    <?php include 'header.php'; ?>

    <!-- ========== HERO SECTION ========== -->
    <section class="policy-hero-section">
        <div class="hero-content">
            <h1>Privacy Policy</h1>
            <p>Your trust and privacy are important to us.</p>
        </div>
    </section>

    <main class="policy-page-wrapper">
        <div class="container">
            <div class="policy-content-card">
                <p class="last-updated">Last Updated: July 18, 2025</p>

                <h2>1. Introduction</h2>
                <p>Welcome to RF Travel & Tours. We are committed to protecting your personal information and your right to privacy. If you have any questions or concerns about this privacy notice, or our practices with regards to your personal information, please contact us at [Your Contact Email].</p>
                <p>This privacy notice describes how we might use your information if you visit our website, engage with us in other related ways, including any sales, marketing, or events. In this privacy notice, if we refer to "we," "us," or "our," we are referring to RF Travel & Tours.</p>

                <h2>2. What Information Do We Collect?</h2>
                <p>We collect personal information that you voluntarily provide to us when you register on the website, express an interest in obtaining information about us or our products and services, or otherwise when you contact us.</p>
                <p>The personal information that we collect depends on the context of your interactions with us and the website, the choices you make, and the products and features you use. The personal information we collect may include the following:</p>
                <ul>
                    <li><strong>Personal Identification Information:</strong> Name, phone number, email address.</li>
                    <li><strong>Account Data:</strong> Usernames, passwords, and other similar security information for account authentication and access.</li>
                    <li><strong>Travel and Booking Information:</strong> Passenger names, flight details, dates of travel, and any other information necessary to complete a booking request.</li>
                    <li><strong>Company Information (for Agents):</strong> Company name, company address, city, and branch.</li>
                </ul>

                <h2>3. How Do We Use Your Information?</h2>
                <p>We use personal information collected via our website for a variety of business purposes described below. We process your personal information for these purposes in reliance on our legitimate business interests, in order to enter into or perform a contract with you, with your consent, and/or for compliance with our legal obligations.</p>
                <ul>
                    <li><strong>To facilitate account creation and logon process.</strong></li>
                    <li><strong>To manage user accounts.</strong> We may use your information for the purposes of managing your account and keeping it in working order.</li>
                    <li><strong>To fulfill and manage your bookings.</strong> We may use your information to fulfill and manage your flight booking requests made through the website.</li>
                    <li><strong>To respond to user inquiries/offer support to users.</strong> We may use your information to respond to your inquiries and solve any potential issues you might have with the use of our Services.</li>
                </ul>

                <h2>4. Will Your Information Be Shared With Anyone?</h2>
                <p>We only share information with your consent, to comply with laws, to provide you with services, to protect your rights, or to fulfill business obligations.</p>
                <p>Specifically, we may need to process your data or share your personal information in the following situations:</p>
                <ul>
                    <li><strong>Airlines and Service Providers:</strong> To complete your booking, we must share your passenger details with the respective airlines or other third-party travel suppliers.</li>
                    <li><strong>Business Transfers:</strong> We may share or transfer your information in connection with, or during negotiations of, any merger, sale of company assets, financing, or acquisition of all or a portion of our business to another company.</li>
                </ul>

                <h2>5. How Do We Keep Your Information Safe?</h2>
                <p>We have implemented appropriate technical and organizational security measures designed to protect the security of any personal information we process. However, despite our safeguards and efforts to secure your information, no electronic transmission over the Internet or information storage technology can be guaranteed to be 100% secure, so we cannot promise or guarantee that hackers, cybercriminals, or other unauthorized third parties will not be able to defeat our security, and improperly collect, access, steal, or modify your information.</p>

                <h2>6. Do We Make Updates to This Notice?</h2>
                <p>Yes, we will update this notice as necessary to stay compliant with relevant laws. The updated version will be indicated by a revised "Last Updated" date and the updated version will be effective as soon as it is accessible. We encourage you to review this privacy notice frequently to be informed of how we are protecting your information.</p>

                <h2>7. How Can You Contact Us About This Notice?</h2>
                <p>If you have questions or comments about this notice, you may <a href="contact-us.php">contact us</a> by email at [Your Contact Email] or by post to:</p>
                <p>
                    <strong>RF Travel & Tours</strong><br>
                    Lahore, Pakistan
                </p>
            </div>
        </div>
    </main>

    <?php include 'floating-icon.php'; ?>
    <?php include 'footer.php'; ?>

</body>

</html>