<?php
session_start();
require_once 'db-config.php';
require_once 'vendor/autoload.php';

if (!isset($_GET['session_id']) || !isset($_SESSION['pending_booking_data'])) {
    header("Location: index.php");
    exit;
}

\Stripe\Stripe::setApiKey('sk_test_YOUR_SECRET_KEY_HERE'); // <-- IMPORTANT

try {
    $session = \Stripe\Checkout\Session::retrieve($_GET['session_id']);

    if ($session->payment_status == 'paid') {
        $booking_data = $_SESSION['pending_booking_data'];

        $booking_ref = 'SPT-' . strtoupper(substr(md5(uniqid(rand(), true)), 0, 8));
        $user_id = (int)$_SESSION['user_id'];
        $booking_type = 'flight';
        $status = 'confirmed';
        $payment_tid = $session->id;

        $sql = "INSERT INTO bookings (user_id, booking_ref, booking_type, flight_details, passenger_details, status, payment_tid, contact_details) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("isssssss", $user_id, $booking_ref, $booking_type, $booking_data['flight_details'], $booking_data['passenger_details'], $status, $payment_tid, $booking_data['contact_details']);

        if ($stmt->execute()) {
            $_SESSION['success_message'] = "Payment successful! Your booking #" . $booking_ref . " is confirmed.";
        } else {
            error_log("CRITICAL: Payment OK (Stripe SID: $payment_tid) but DB insert failed. Error: " . $stmt->error);
            $_SESSION['error_message'] = "Your payment was successful, but there was an error saving your booking. Please contact support with Transaction ID: $payment_tid";
        }
        unset($_SESSION['pending_booking_data']);
    } else {
        $_SESSION['error_message'] = "Payment was not completed successfully. Please try again.";
        unset($_SESSION['pending_booking_data']);
    }
} catch (Exception $e) {
    $_SESSION['error_message'] = "Could not verify your payment session. Please contact support.";
    unset($_SESSION['pending_booking_data']);
}

header("Location: my-flights.php");
exit;