<?php
session_start();
include_once '../db-config.php';

function e($string) { return htmlspecialchars($string ?? '', ENT_QUOTES, 'UTF-8'); }

if (!isset($_SESSION['user_id']) || !isset($_SESSION['user_type']) || $_SESSION['user_type'] !== 'admin') {
    header("location: ../login.php");
    exit;
}

// --- 1. SETUP FILTERS & DATA LISTS ---
$filter_user_id_raw = $_GET['user_id'] ?? '0';
$filter_vendor_id_raw = $_GET['vendor_id'] ?? '0';
$filter_start_date = $_GET['start_date'] ?? '';
$filter_end_date = $_GET['end_date'] ?? '';

$users_list = $conn->query("SELECT id, name, user_type FROM users WHERE user_type IN ('customer', 'agent') ORDER BY name ASC")->fetch_all(MYSQLI_ASSOC);
$vendors_list = $conn->query("SELECT id, name FROM vendors ORDER BY name ASC")->fetch_all(MYSQLI_ASSOC);
$cost_types = ['pilgrim', 'transport', 'ticket', 'hotel_specific', 'service_specific', 'hotel_main', 'service_main'];

// --- 2. CALCULATE OPENING BALANCE ---
$ledger_opening_balance = 0;
if (!empty($filter_start_date)) {
    // This logic is complex but necessary to accurately calculate the balance before the selected start date
    // It mirrors the main transaction query but with a date filter of "< ?"
    $op_sql_parts = []; $op_params = []; $op_types = '';
    // Define WHERE clauses and parameters for each data source for the opening balance calculation
    $op_where_receivable_pkg = ["i.issue_date < ?"]; $op_params_receivable_pkg = [$filter_start_date]; $op_types_receivable_pkg = 's';
    $op_where_receivable_tkt = ["ti.issue_date < ?"]; $op_params_receivable_tkt = [$filter_start_date]; $op_types_receivable_tkt = 's';
    $op_where_cost = ["i.issue_date < ?"]; $op_params_cost = [$filter_start_date]; $op_types_cost = 's';
    $op_where_cost_tkt = ["ti.issue_date < ?"]; $op_params_cost_tkt = [$filter_start_date]; $op_types_cost_tkt = 's';
    $op_where_pay = ["p.payment_date < ?"]; $op_params_pay = [$filter_start_date]; $op_types_pay = 's';

    // Apply User and Vendor filters to all parts of the opening balance query
    if (is_numeric($filter_user_id_raw) && $filter_user_id_raw > 0) {
        $op_where_receivable_pkg[] = "i.user_id = ?"; $op_params_receivable_pkg[] = (int)$filter_user_id_raw; $op_types_receivable_pkg .= 'i';
        $op_where_receivable_tkt[] = "ti.user_id = ?"; $op_params_receivable_tkt[] = (int)$filter_user_id_raw; $op_types_receivable_tkt .= 'i';
        $op_where_cost[] = "i.user_id = ?"; $op_params_cost[] = (int)$filter_user_id_raw; $op_types_cost .= 'i';
        $op_where_cost_tkt[] = "ti.user_id = ?"; $op_params_cost_tkt[] = (int)$filter_user_id_raw; $op_types_cost_tkt .= 'i';
        $op_where_pay[] = "p.user_id = ?"; $op_params_pay[] = (int)$filter_user_id_raw; $op_types_pay .= 'i';
    } elseif ($filter_user_id_raw === 'none') {
        $op_where_receivable_pkg[] = "i.user_id IS NULL"; $op_where_receivable_tkt[] = "ti.user_id IS NULL"; $op_where_cost[] = "i.user_id IS NULL"; $op_where_cost_tkt[] = "ti.user_id IS NULL"; $op_where_pay[] = "p.user_id IS NULL";
    } elseif ($filter_user_id_raw === 'all_vendors') {
        $op_where_receivable_pkg[] = "1=0"; $op_where_receivable_tkt[] = "1=0";
    }

    if (is_numeric($filter_vendor_id_raw) && $filter_vendor_id_raw > 0) {
        $op_where_cost_tkt[] = "ti.vendor_id = ?"; $op_params_cost_tkt[] = (int)$filter_vendor_id_raw; $op_types_cost_tkt .= 'i';
        $op_where_pay[] = "p.vendor_id = ?"; $op_params_pay[] = (int)$filter_vendor_id_raw; $op_types_pay .= 'i';
    } elseif ($filter_vendor_id_raw === 'none') {
        $op_where_cost_tkt[] = "ti.vendor_id IS NULL"; $op_where_pay[] = "p.vendor_id IS NULL";
    } elseif ($filter_vendor_id_raw === 'all_users') {
        $op_where_cost_tkt[] = "1=0"; $op_where_pay[] = "p.vendor_id IS NULL";
    }

    // Build the final opening balance query string
    $op_sql_parts[] = "(SELECT i.grand_total_pkr as debit, 0 as credit FROM invoices i WHERE " . implode(' AND ', $op_where_receivable_pkg) . ")";
    $op_params = array_merge($op_params, $op_params_receivable_pkg); $op_types .= $op_types_receivable_pkg;
    $op_sql_parts[] = "(SELECT ti.grand_total_pkr as debit, 0 as credit FROM ticket_invoices ti WHERE " . implode(' AND ', $op_where_receivable_tkt) . ")";
    $op_params = array_merge($op_params, $op_params_receivable_tkt); $op_types .= $op_types_receivable_tkt;
    $op_sql_parts[] = "(SELECT p.debit_amount as debit, p.credit_amount as credit FROM payments p WHERE " . implode(' AND ', $op_where_pay) . ")";
    $op_params = array_merge($op_params, $op_params_pay); $op_types .= $op_types_pay;

    // Execute the query
    $final_op_sql = "SELECT SUM(debit - credit) as opening_balance FROM (" . implode(" UNION ALL ", $op_sql_parts) . ") AS opening_parts";
    $stmt_op = $conn->prepare($final_op_sql);
    if ($stmt_op) {
        if (!empty($op_params)) { $stmt_op->bind_param($op_types, ...$op_params); }
        $stmt_op->execute();
        $ledger_opening_balance = (float)($stmt_op->get_result()->fetch_assoc()['opening_balance'] ?? 0);
        $stmt_op->close();
    }
}


// --- 3. BUILD WHERE CLAUSES & PARAMS for main query (same as before) ---
$where_receivable_pkg = []; $params_receivable_pkg = []; $types_receivable_pkg = ''; $where_receivable_tkt = []; $params_receivable_tkt = []; $types_receivable_tkt = ''; $where_cost = []; $params_cost = []; $types_cost = ''; $where_cost_tkt = []; $params_cost_tkt = []; $types_cost_tkt = ''; $where_pay = []; $params_pay = []; $types_pay = '';
if (!empty($filter_start_date)) { $where_receivable_pkg[] = "i.issue_date >= ?"; $params_receivable_pkg[] = $filter_start_date; $types_receivable_pkg .= 's'; $where_receivable_tkt[] = "ti.issue_date >= ?"; $params_receivable_tkt[] = $filter_start_date; $types_receivable_tkt .= 's'; $where_cost[] = "i.issue_date >= ?"; $params_cost[] = $filter_start_date; $types_cost .= 's'; $where_cost_tkt[] = "ti.issue_date >= ?"; $params_cost_tkt[] = $filter_start_date; $types_cost_tkt .= 's'; $where_pay[] = "p.payment_date >= ?"; $params_pay[] = $filter_start_date; $types_pay .= 's'; }
if (!empty($filter_end_date)) { $where_receivable_pkg[] = "i.issue_date <= ?"; $params_receivable_pkg[] = $filter_end_date; $types_receivable_pkg .= 's'; $where_receivable_tkt[] = "ti.issue_date <= ?"; $params_receivable_tkt[] = $filter_end_date; $types_receivable_tkt .= 's'; $where_cost[] = "i.issue_date <= ?"; $params_cost[] = $filter_end_date; $types_cost .= 's'; $where_cost_tkt[] = "ti.issue_date <= ?"; $params_cost_tkt[] = $filter_end_date; $types_cost_tkt .= 's'; $where_pay[] = "p.payment_date <= ?"; $params_pay[] = $filter_end_date; $types_pay .= 's'; }
if (is_numeric($filter_user_id_raw) && $filter_user_id_raw > 0) { $where_receivable_pkg[] = "i.user_id = ?"; $params_receivable_pkg[] = (int)$filter_user_id_raw; $types_receivable_pkg .= 'i'; $where_receivable_tkt[] = "ti.user_id = ?"; $params_receivable_tkt[] = (int)$filter_user_id_raw; $types_receivable_tkt .= 'i'; $where_cost[] = "i.user_id = ?"; $params_cost[] = (int)$filter_user_id_raw; $types_cost .= 'i'; $where_cost_tkt[] = "ti.user_id = ?"; $params_cost_tkt[] = (int)$filter_user_id_raw; $types_cost_tkt .= 'i'; $where_pay[] = "p.user_id = ?"; $params_pay[] = (int)$filter_user_id_raw; $types_pay .= 'i'; } elseif ($filter_user_id_raw === 'none') { $where_receivable_pkg[] = "i.user_id IS NULL"; $where_receivable_tkt[] = "ti.user_id IS NULL"; $where_cost[] = "i.user_id IS NULL"; $where_cost_tkt[] = "ti.user_id IS NULL"; $where_pay[] = "p.user_id IS NULL"; } elseif ($filter_user_id_raw === 'all_vendors') { $where_receivable_pkg[] = "1=0"; $where_receivable_tkt[] = "1=0"; }
if (is_numeric($filter_vendor_id_raw) && $filter_vendor_id_raw > 0) { $where_cost_tkt[] = "ti.vendor_id = ?"; $params_cost_tkt[] = (int)$filter_vendor_id_raw; $types_cost_tkt .= 'i'; $where_pay[] = "p.vendor_id = ?"; $params_pay[] = (int)$filter_vendor_id_raw; $types_pay .= 'i'; } elseif ($filter_vendor_id_raw === 'none') { $where_cost_tkt[] = "ti.vendor_id IS NULL"; $where_pay[] = "p.vendor_id IS NULL"; } elseif ($filter_vendor_id_raw === 'all_users') { $where_cost_tkt[] = "1=0"; $where_pay[] = "p.vendor_id IS NULL"; }
$where_receivable_pkg_str = !empty($where_receivable_pkg) ? 'WHERE ' . implode(' AND ', $where_receivable_pkg) : ''; $where_receivable_tkt_str = !empty($where_receivable_tkt) ? 'WHERE ' . implode(' AND ', $where_receivable_tkt) : ''; $where_cost_tkt_str = !empty($where_cost_tkt) ? 'WHERE ' . implode(' AND ', $where_cost_tkt) : ''; $where_pay_str = !empty($where_pay) ? 'WHERE ' . implode(' AND ', $where_pay) : '';

// --- 4. FETCH TRANSACTIONS (CORRECTED, ROBUST QUERY) ---
$sql_parts = []; $params_period = []; $types_period = ''; $collation_fix = "COLLATE utf8mb4_unicode_ci";
// Package Invoices (Receivables)
$sql_parts[] = "(SELECT i.id AS original_id, i.issue_date AS transaction_date, CAST('Booking' AS CHAR(50)) $collation_fix, CAST(i.invoice_number AS CHAR(255)) $collation_fix, CAST(CONCAT(i.guest_name, ' x ', (SELECT COUNT(*) FROM invoice_pilgrims ip WHERE ip.invoice_id = i.id), ' Pax') AS CHAR(255)) $collation_fix, CAST('' AS CHAR(255)) $collation_fix, i.grand_total_pkr AS debit, 0 AS credit, i.id AS link_id, CAST('package' AS CHAR(50)) $collation_fix FROM invoices i $where_receivable_pkg_str)"; $params_period = array_merge($params_period, $params_receivable_pkg); $types_period .= $types_receivable_pkg;
// Ticket Invoices (Receivables)
$sql_parts[] = "(SELECT ti.id, ti.issue_date, CAST('Ticket' AS CHAR(50)) $collation_fix, CAST(ti.invoice_number AS CHAR(255)) $collation_fix, CAST(CONCAT(ti.guest_name, ' x ', (SELECT COUNT(*) FROM ticket_invoice_passengers tip WHERE tip.ticket_invoice_id = ti.id), ' Pax') AS CHAR(255)) $collation_fix, CAST('' AS CHAR(255)) $collation_fix, ti.grand_total_pkr, 0, ti.id, CAST('ticket' AS CHAR(50)) $collation_fix FROM ticket_invoices ti $where_receivable_tkt_str)"; $params_period = array_merge($params_period, $params_receivable_tkt); $types_period .= $types_receivable_tkt;
// Vendor Costs for Tickets
$where_cost_tkt_str .= (empty($where_cost_tkt) ? 'WHERE ' : ' AND ') . "ti.grand_total_pkr_cost > 0";
$sql_parts[] = "(SELECT ti.id, ti.issue_date, CAST('Vendor Cost' AS CHAR(50)) $collation_fix, CAST(ti.invoice_number AS CHAR(255)) $collation_fix, CAST(CONCAT('Cost for Ticket Inv: ', ti.guest_name) AS CHAR(255)) $collation_fix, CAST('' AS CHAR(255)) $collation_fix, 0, ti.grand_total_pkr_cost, ti.id, CAST('ticket' AS CHAR(50)) $collation_fix FROM ticket_invoices ti $where_cost_tkt_str)"; $params_period = array_merge($params_period, $params_cost_tkt); $types_period .= $types_cost_tkt;
// Payments
$sql_parts[] = "(SELECT p.id, p.payment_date, CAST(CASE WHEN p.debit_amount > 0 AND p.payment_method IN ('Bank Transfer', 'Card') THEN 'BP' WHEN p.debit_amount > 0 AND p.payment_method = 'Cash' THEN 'CP' WHEN p.credit_amount > 0 AND p.payment_method IN ('Bank Transfer', 'Card') THEN 'BR' WHEN p.credit_amount > 0 AND p.payment_method = 'Cash' THEN 'CR' WHEN p.debit_amount > 0 THEN 'Expense / Paid' ELSE 'Payment Received' END AS CHAR(50)) $collation_fix, CAST(CASE WHEN p.debit_amount > 0 AND p.payment_method IN ('Bank Transfer', 'Card') THEN CONCAT('BP-', p.id) WHEN p.debit_amount > 0 AND p.payment_method = 'Cash' THEN CONCAT('CP-', p.id) WHEN p.credit_amount > 0 AND p.payment_method IN ('Bank Transfer', 'Card') THEN CONCAT('BR-', p.id) WHEN p.credit_amount > 0 AND p.payment_method = 'Cash' THEN CONCAT('CR-', p.id) ELSE CONCAT('PAY-', p.id) END AS CHAR(255)) $collation_fix, CAST(p.notes AS CHAR(255)) $collation_fix, CAST(p.invoice_reference AS CHAR(255)) $collation_fix, p.debit_amount, p.credit_amount, p.invoice_id, CAST(p.invoice_type AS CHAR(50)) $collation_fix FROM payments p $where_pay_str)"; $params_period = array_merge($params_period, $params_pay); $types_period .= $types_pay;
$final_sql = implode(" UNION ALL ", $sql_parts) . " ORDER BY transaction_date ASC, original_id ASC, credit ASC, debit ASC";
$transactions_raw = [];
$stmt_period = $conn->prepare($final_sql);
if ($stmt_period) {
    if (!empty($params_period)) { $stmt_period->bind_param($types_period, ...$params_period); }
    $stmt_period->execute();
    $result = $stmt_period->get_result();
    if ($result) { $transactions_raw = $result->fetch_all(MYSQLI_ASSOC); }
    $stmt_period->close();
}

// --- 5. CALCULATE SUMMARY STATISTICS (same as before) ---
$summary_stats = ['package_invoice_count' => 0, 'ticket_invoice_count' => 0, 'pilgrim_count' => 0, 'hotel_count' => 0];
$stats_params = array_merge($params_receivable_pkg, $params_receivable_tkt, $params_receivable_pkg, $params_receivable_pkg); $stats_types = $types_receivable_pkg . $types_receivable_tkt . $types_receivable_pkg . $types_receivable_pkg;
$stats_sql_base = "SELECT (SELECT COUNT(id) FROM invoices i %s) as package_invoice_count, (SELECT COUNT(id) FROM ticket_invoices ti %s) as ticket_invoice_count, (SELECT COUNT(ip.id) FROM invoice_pilgrims ip LEFT JOIN invoices i ON ip.invoice_id = i.id %s) as pilgrim_count, (SELECT COUNT(ih.id) FROM invoice_hotels ih LEFT JOIN invoices i ON ih.invoice_id = i.id %s) as hotel_count";
$final_stats_sql = sprintf($stats_sql_base, $where_receivable_pkg_str, $where_receivable_tkt_str, $where_receivable_pkg_str, $where_receivable_pkg_str);
$stmt_stats = $conn->prepare($final_stats_sql); if ($stmt_stats) { if (!empty($stats_params)) { $stmt_stats->bind_param($stats_types, ...$stats_params); } $stmt_stats->execute(); $stats_result = $stmt_stats->get_result(); if ($stats_result) { $summary_stats = $stats_result->fetch_assoc(); } $stmt_stats->close(); }

// --- 6. PROCESS DATA FOR TABLE DISPLAY & CALCULATE PERIOD TOTALS (same as before) ---
$transactions = []; $ledger_running_balance = $ledger_opening_balance; $total_receivables_period = 0; $total_payments_received_period = 0; $total_expenses_paid_period = 0; $total_costs_incurred_period = 0;
foreach ($transactions_raw as $t) {
    // Correctly handle NULL values from UNION
    $transaction_data = [
        'transaction_date' => $t['transaction_date'] ?? null, 'transaction_type' => $t['transaction_type'] ?? null, 'trans_num' => $t['trans_num'] ?? null,
        'particulars' => $t['particulars'] ?? null, 'invoice_reference' => $t['invoice_reference'] ?? null, 'debit' => $t['debit'] ?? 0,
        'credit' => $t['credit'] ?? 0, 'link_id' => $t['link_id'] ?? null, 'link_type' => $t['link_type'] ?? null
    ];
    $debit = (float)$transaction_data['debit']; $credit = (float)$transaction_data['credit'];
    if (strpos((string)$transaction_data['transaction_type'], 'Booking') !== false || strpos((string)$transaction_data['transaction_type'], 'Ticket') !== false && strpos((string)$transaction_data['transaction_type'], 'Cost') === false) { $total_receivables_period += $debit; }
    elseif (strpos((string)$transaction_data['transaction_type'], 'Cost') !== false) { $total_costs_incurred_period += $credit; } elseif ($debit > 0) { $total_expenses_paid_period += $debit; } else { $total_payments_received_period += $credit; }
    $ledger_running_balance += $debit - $credit; $transaction_data['balance'] = $ledger_running_balance; $transactions[] = $transaction_data;
}
$summary_net_profit = $total_receivables_period - $total_costs_incurred_period; $summary_closing_balance = $ledger_opening_balance + $total_receivables_period - $total_payments_received_period;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>General Ledger</title>
    <link rel="icon" type="image/png" href="../images/logo-icon.png">
    <link rel="stylesheet" href="admin-style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
</head>
<body>
    <div class="dashboard-wrapper">
        <?php include 'sidebar.php'; ?>
        <div class="main-content">
            <header class="main-header">
                <button class="menu-toggle" id="menu-toggle"><i class="fas fa-bars"></i></button>
                <div class="user-info"><span>General Ledger</span></div>
            </header>
            <main class="content-body">
                <div class="content-card">
                    <div class="card-body">
                        <form method="GET" action="admin-ledger.php" class="styled-form">
                            <div class="form-grid">
                                <div class="form-group"><label>Start Date</label><input type="date" name="start_date" value="<?= e($filter_start_date) ?>" class="form-control"></div>
                                <div class="form-group"><label>End Date</label><input type="date" name="end_date" value="<?= e($filter_end_date) ?>" class="form-control"></div>
                                <div class="form-group"><label>Filter By User</label>
                                    <select name="user_id" class="form-control">
                                        <option value="0" <?= ($filter_user_id_raw == '0') ? 'selected' : '' ?>>All Users & Expenses</option>
                                        <option value="none" <?= ($filter_user_id_raw == 'none') ? 'selected' : '' ?>>Direct Customers Only</option>
                                        <option value="all_vendors" <?= ($filter_user_id_raw == 'all_vendors') ? 'selected' : '' ?>>All Vendors (No User Data)</option>
                                        <?php foreach ($users_list as $user): ?><option value="<?= e($user['id']) ?>" <?= ($filter_user_id_raw == $user['id']) ? 'selected' : '' ?>><?= e($user['name']) ?> - [<?= e(strtoupper(substr($user['user_type'], 0, 1))) ?>]</option><?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="form-group"><label>Filter By Vendor</label>
                                    <select name="vendor_id" class="form-control">
                                        <option value="0" <?= ($filter_vendor_id_raw == '0') ? 'selected' : '' ?>>All Vendors</option>
                                        <option value="none" <?= ($filter_vendor_id_raw == 'none') ? 'selected' : '' ?>>Direct / No Vendor</option>
                                        <option value="all_users" <?= ($filter_vendor_id_raw == 'all_users') ? 'selected' : '' ?>>All Users (No Vendor Data)</option>
                                        <?php foreach ($vendors_list as $vendor): ?><option value="<?= e($vendor['id']) ?>" <?= ($filter_vendor_id_raw == $vendor['id']) ? 'selected' : '' ?>><?= e($vendor['name']) ?></option><?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="form-actions">
                                <a href="ledger-print.php?<?= http_build_query($_GET) ?>" target="_blank" class="btn btn-info"><i class="fas fa-print"></i> Print View</a>
                                <a href="admin-ledger.php" class="btn btn-secondary"><i class="fas fa-times"></i> Clear</a>
                                <button type="submit" class="btn btn-primary"><i class="fas fa-filter"></i> Filter</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="form-grid">
                    <div class="summary-item"><div class="label">Opening Balance</div><div class="value balance"><?= number_format($ledger_opening_balance, 0) ?></div></div>
                    <div class="summary-item"><div class="label">Receivables</div><div class="value receivable"><?= number_format($total_receivables_period, 0) ?></div></div>
                    <div class="summary-item"><div class="label">Received</div><div class="value payment"><?= number_format($total_payments_received_period, 0) ?></div></div>
                    <div class="summary-item"><div class="label">Closing Balance</div><div class="value balance"><?= number_format($summary_closing_balance, 0) ?></div></div>
                    <div class="summary-item"><div class="label">Payable</div><div class="value cost"><?= number_format($total_costs_incurred_period, 0) ?></div></div>
                    <div class="summary-item"><div class="label">Paid</div><div class="value expense"><?= number_format($total_expenses_paid_period, 0) ?></div></div>
                    <div class="summary-item"><div class="label">Net Profit</div><div class="value profit"><?= number_format($summary_net_profit, 0) ?></div></div>
                </div>
                <div class="content-card">
                    <div class="table-responsive">
                        <table>
                            <thead><tr><th>Date</th><th>Type</th><th>Trans.#</th><th>Particulars</th><th>Inv/Ref</th><th style="text-align:right;">Debit</th><th style="text-align:right;">Credit</th><th style="text-align:right;">Balance</th></tr></thead>
                            <tbody>
                                <?php if (!empty($filter_start_date)): ?><tr><td><?= date('d M, Y', strtotime($filter_start_date)) ?></td><td colspan="6"><strong>Opening Balance</strong></td><td style="text-align:right; font-weight:bold;"><?= number_format($ledger_opening_balance, 2) ?></td></tr><?php endif; ?>
                                <?php if (empty($transactions)): ?><tr><td colspan="8" class="empty-state">No transactions found.</td></tr><?php else: foreach ($transactions as $t): ?>
                                    <tr>
                                        <td><?= date('d M, Y', strtotime(e($t['transaction_date']))) ?></td>
                                        <td><?= e($t['transaction_type']) ?></td>
                                        <td><?= e($t['trans_num']) ?></td>
                                        <td>
                                            <?php if ($t['link_id'] && ($t['transaction_type'] === 'Booking' || $t['transaction_type'] === 'Ticket')): ?>
                                                <a href="<?= ($t['link_type'] === 'ticket') ? 'ticket-invoice-edit.php' : 'edit-invoice.php' ?>?id=<?= e($t['link_id']) ?>" target="_blank"><?= e($t['particulars']) ?></a>
                                            <?php else: ?>
                                                <?= e($t['particulars']) ?>
                                            <?php endif; ?>
                                        </td>
                                        <td><?= e($t['invoice_reference']) ?></td>
                                        <td style="text-align:right; color: var(--danger-color);"><?= (float)$t['debit'] > 0 ? number_format((float)$t['debit'], 2) : '' ?></td>
                                        <td style="text-align:right; color: var(--success-color);"><?= (float)$t['credit'] > 0 ? number_format((float)$t['credit'], 2) : '' ?></td>
                                        <td style="text-align:right; font-weight:600;"><?= number_format((float)$t['balance'], 2) ?></td>
                                    </tr>
                                <?php endforeach; endif; ?>
                            </tbody>
                            <tfoot><tr style="font-weight: bold;"><td colspan="5" style="text-align: right;">Total for Period:</td><td style="text-align:right;"><?= number_format($total_receivables_period + $total_expenses_paid_period, 2) ?></td><td style="text-align:right;"><?= number_format($total_costs_incurred_period + $total_payments_received_period, 2) ?></td><td style="text-align:right;"><?= number_format($ledger_running_balance, 2) ?></td></tr></tfoot>
                        </table>
                    </div>
                </div>
            </main>
        </div>
    </div>
</body>
</html>