<!-- =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= -->
<!-- === ALL TOURS SECTION (COMBINED, WITH TABS & PAGINATION) === -->
<!-- =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= -->
<section class="all-tours-section">
    <div class="listings-container">
        <?php
        // --- 1. DETERMINE ACTIVE TAB & SETUP PAGINATION ---
        $active_tab = $_GET['type'] ?? 'domestic';
        $results_per_page = 20; // You can change this number
        $current_page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
        $offset = ($current_page - 1) * $results_per_page;
        $whatsapp_number = '923052394810'; // Central WhatsApp number for fallbacks

        // --- 2. SELECT THE CORRECT DATABASE TABLE ---
        if ($active_tab === 'international') {
            $table_name = 'international_tours';
        } else {
            $table_name = 'domestic_tours'; // Default to domestic
        }

        // --- 3. BUILD AND EXECUTE THE SQL QUERY ---
        // First, get the total count for pagination
        $count_sql = "SELECT COUNT(id) FROM `{$table_name}` WHERE is_active = 1";
        $total_records_result = $conn->query($count_sql);
        $total_records = $total_records_result->fetch_row()[0];
        $total_pages = ceil($total_records / $results_per_page);

        // Now, get the records for the current page
        $sql = "SELECT * FROM `{$table_name}` 
                WHERE is_active = 1 
                ORDER BY display_order ASC, last_updated DESC 
                LIMIT ? OFFSET ?";
        
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ii", $results_per_page, $offset);
        $stmt->execute();
        $result = $stmt->get_result();
        ?>

        <!-- Section Header -->
        <div class="listings-header">
            <div class="listings-header-text">
                <h2 class="listings-title">Explore Our Tours</h2>
                <p class="listings-subtitle">From the peaks of Pakistan to global wonders, your next adventure starts here.</p>
            </div>
        </div>

        <!-- Responsive Tab / Select Switch Controls -->
        <div class="tour-filter-controls">
            <!-- DESKTOP TABS -->
            <div class="tour-type-tabs">
                <a href="?type=domestic" class="filter-tab <?= ($active_tab === 'domestic' ? 'active' : '') ?>">Domestic</a>
                <a href="?type=international" class="filter-tab <?= ($active_tab === 'international' ? 'active' : '') ?>">International</a>
            </div>

            <!-- MOBILE DROPDOWN -->
            <div class="tour-type-select-wrapper">
                <i class="fa-solid fa-globe select-icon"></i>
                <select class="tour-type-select" onchange="window.location.href = this.value;">
                    <option value="?type=domestic" <?= ($active_tab === 'domestic' ? 'selected' : '') ?>>Domestic Tours</option>
                    <option value="?type=international" <?= ($active_tab === 'international' ? 'selected' : '') ?>>International Tours</option>
                </select>
            </div>
        </div>
        
        <!-- Invisible anchor for smooth scrolling -->
        <span id="all-tours-anchor"></span>

        <!-- Grid Wrapper -->
        <div class="tours-grid-wrapper">
            <div class="tours-grid">
                <?php
                if ($result && $result->num_rows > 0):
                    while ($tour = $result->fetch_assoc()):

                        // ================================================================
                        // ===== SMART LINK LOGIC TO DETERMINE THE CORRECT BUTTON LINK ====
                        // ================================================================
                        $link_url = '#';
                        $button_text = 'View Details';
                        $link_target = '_self';

                        if (!empty($tour['page_link'])) {
                            // If a page link exists, link to the generated page.
                            $link_url = htmlspecialchars($tour['page_link']) . '.php';
                            $button_text = 'View Tour Details';
                        } else {
                            // FALLBACK: If no page link, link directly to WhatsApp.
                            $whatsapp_message = urlencode("Hi, I'm interested in the tour: '" . $tour['tour_name'] . "'.");
                            $link_url = "https://wa.me/{$whatsapp_number}?text={$whatsapp_message}";
                            $button_text = 'Enquire on WhatsApp';
                            $link_target = '_blank';
                        }
                        // ================================================================
                        // =================== END OF SMART LINK LOGIC ====================
                        // ================================================================
                ?>
                        <!-- DYNAMIC Tour Card -->
                        <div class="tour-card">
                            <img src="<?= htmlspecialchars($tour['image_url']) ?>" alt="Image of <?= htmlspecialchars($tour['tour_name']) ?>" class="tour-card-image">
                            <div class="tour-card-content">
                                <h3 class="tour-name"><?= htmlspecialchars($tour['tour_name']) ?></h3>
                                <p class="tour-location"><i class="fa-solid fa-location-dot"></i> <?= htmlspecialchars($tour['location']) ?></p>
                                <div class="tour-details">
                                    <span><i class="fa-solid fa-clock"></i> <?= htmlspecialchars($tour['duration_days']) ?> Days</span>
                                    <span><i class="fa-solid fa-user-group"></i> <?= htmlspecialchars($tour['audience']) ?></span>
                                </div>
                                <p class="tour-price">from 
                                    <span>
                                        <?= isset($tour['price_currency']) ? htmlspecialchars($tour['price_currency']) : 'PKR' ?> 
                                        <?= number_format($tour['price_per_person']) ?>
                                    </span>/person
                                </p>
                                <!-- THE BUTTON BELOW IS NOW DYNAMIC -->
                                <a href="<?= $link_url ?>" target="<?= $link_target ?>" class="btn-view-deal"><?= $button_text ?></a>
                            </div>
                        </div>
                <?php
                    endwhile;
                else:
                    echo '<p style="text-align: center; width: 100%; padding: 2rem 0; grid-column: 1 / -1;">No ' . htmlspecialchars($active_tab) . ' tours found. Please check back soon.</p>';
                endif;
                ?>
            </div>
        </div>

        <!-- Pagination Controls -->
        <?php if ($total_pages > 1): ?>
            <nav class="pagination-container">
                <ul class="pagination">
                    <?php
                    $query_params = $_GET; // Use existing query params like 'type'

                    // Previous button
                    if ($current_page > 1) {
                        $query_params['page'] = $current_page - 1;
                        echo '<li><a href="?' . http_build_query($query_params) . '#all-tours-anchor">« Prev</a></li>';
                    }
                    // Page number links
                    for ($i = 1; $i <= $total_pages; $i++) {
                        $query_params['page'] = $i;
                        echo '<li><a href="?' . http_build_query($query_params) . '#all-tours-anchor" class="' . ($i == $current_page ? 'active' : '') . '">' . $i . '</a></li>';
                    }
                    // Next button
                    if ($current_page < $total_pages) {
                        $query_params['page'] = $current_page + 1;
                        echo '<li><a href="?' . http_build_query($query_params) . '#all-tours-anchor">Next »</a></li>';
                    }
                    ?>
                </ul>
            </nav>
        <?php endif; ?>
    </div>
</section>

<!-- ======================================================== -->
<!--   CSS FOR RESPONSIVE TABS (Add to your stylesheet)       -->
<!-- ======================================================== -->
<style>

.all-tours-section {
    padding: 200px 0; /* Adjusted padding */
    background-color: #f8f9fa;
}

    /* Wrapper for all filter controls */
    .tour-filter-controls {
        margin-bottom: 40px;
        display: flex;
        justify-content: center;
    }

    /* DESKTOP TAB STYLES (UNDERLINE STYLE) */
    .tour-type-tabs {
        display: flex;
        gap: 30px;
        border-bottom: 1px solid #ddd;
    }
    .filter-tab {
        padding: 10px 15px;
        padding-bottom: 15px;
        color: var(--text-light, #666);
        text-decoration: none;
        font-weight: 600;
        font-size: 1.1rem;
        border-bottom: 3px solid transparent;
        transition: all 0.2s ease-in-out;
        transform: translateY(1px);
    }
    .filter-tab:hover {
        color: var(--primary-dark, #2c3e50);
    }
    .filter-tab.active {
        color: var(--primary-dark, #2c3e50);
        border-bottom-color: var(--primary-dark, #2c3e50);
        cursor: default;
    }

    /* MOBILE DROPDOWN */
    .tour-type-select-wrapper {
        display: none;
        position: relative;
        width: 100%;
        max-width: 400px;
        margin: 0 auto;
    }
    .tour-type-select {
        width: 100%; padding: 12px 15px 12px 45px; border: 1px solid #ddd;
        border-radius: 8px; font-size: 1rem; cursor: pointer; -webkit-appearance: none;
        appearance: none; background-color: var(--white, #fff);
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e");
        background-repeat: no-repeat; background-position: right 0.75rem center; background-size: 16px 12px;
    }
    .select-icon {
        position: absolute; left: 15px; top: 50%; transform: translateY(-50%);
        color: #999; pointer-events: none;
    }

    /* RESPONSIVE SWITCH FOR TABS */
    @media (max-width: 768px) {
        .all-tours-section {
    padding: 100px 0; /* Adjusted padding */
    background-color: #f8f9fa;
}
        .tour-type-tabs {
            display: none; /* Hide tabs on mobile */
        }
        .tour-type-select-wrapper {
            display: block; /* Show dropdown on mobile */
        }
    }

    #all-tours-anchor { display: block; position: relative; top: -100px; visibility: hidden; }

    /* DESKTOP GRID LAYOUT (Unchanged) */
    .tours-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 2rem; }
    
    .tours-grid-wrapper {
        /* This wrapper is kept for potential future use but isn't strictly necessary for this layout */
    }

    /* Unchanged Tour Card styles */
    .tour-card { background: var(--white); border-radius: 12px; overflow: hidden; box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08); transition: transform 0.3s ease, box-shadow 0.3s ease; display: flex; flex-direction: column; }
    .tour-card:hover { transform: translateY(-8px); box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12); }
    .tour-card-image { width: 100%; height: 200px; object-fit: cover; }
    .tour-card-content { padding: 1.5rem; display: flex; flex-direction: column; flex-grow: 1; }
    .tour-name { font-size: 1.25rem; font-weight: 600; color: var(--text-dark); margin: 0 0 0.25rem 0; }
    .tour-location { font-size: 0.9rem; color: var(--text-light); margin-bottom: 1rem; }
    .tour-details { display: flex; gap: 1.5rem;  padding: 1rem 0; border-top: 1px solid #f0f0f0; margin-top: auto; }
    .tour-details span { font-size: 0.9rem; font-weight: 500; color: var(--text-dark); display: flex; align-items: center; gap: 0.5rem; }
    .tour-details i { color: var(--primary-gold); }
    .tour-price { font-size: 1rem; color: var(--text-light); margin: 1rem 0; }
    .tour-price span { font-weight: 700; font-size: 1.2rem; color: var(--text-dark); }
    .btn-view-deal { display: block; width: 100%; background-color: var(--primary-dark); color: var(--white); text-align: center; text-decoration: none; padding: 0.75rem; border-radius: 8px; font-weight: 500; transition: background-color 0.2s ease; }
    .btn-view-deal:hover { background-color: #000; }

    /* RESPONSIVE GRID ADJUSTMENTS */
    @media (max-width: 992px) {
        .tours-grid {
            grid-template-columns: repeat(2, 1fr); /* 2 columns for tablets */
        }
    }
    @media (max-width: 768px) {
        .tours-grid {
            grid-template-columns: 1fr; /* 1 column for mobile */
        }
    }

    /* Pagination Styles (Unchanged) */
    .pagination-container { margin-top: 50px; display: flex; justify-content: center; }
    .pagination { list-style: none; padding: 0; display: flex; flex-wrap: wrap; justify-content: center; gap: 8px; }
    .pagination li a { display: block; padding: 10px 15px; text-decoration: none; color: var(--text-dark, #333); background-color: var(--white, #fff); border: 1px solid #ddd; border-radius: 8px; font-weight: 500; transition: all 0.3s ease; }
    .pagination li a:hover, .pagination li a.active { background-color: var(--primary-dark, #2c3e50); color: var(--white, #fff); border-color: var(--primary-dark, #2c3e50); }
    .pagination li a.active { cursor: default; }
</style>