<?php
// We need to start the session to show the correct header state (logged in/out)
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
?>
<!DOCTYPE html>
<html>

<head>
    <title>Contact Us - RF Travel & Tours</title>
    <meta charset="UTF-8">
    <link rel="icon" type="image/png" href="images/logo-icon.png">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Main Stylesheet (for variables) -->
    <link rel="stylesheet" href="css/style.css">
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css">
    <!-- NEW dedicated stylesheet for this page -->
    <link rel="stylesheet" href="css/contact-style.css">
</head>

<body>

    <?php include 'header.php'; ?>

    <!-- ========== HERO SECTION ========== -->
    <section class="contact-hero-section">
        <div class="hero-content">
            <h1>Get in Touch</h1>
            <p>We're here to help you plan your next adventure. Contact us with any questions or inquiries.</p>
        </div>
    </section>

    <main class="contact-page-wrapper">
        <div class="container">
            <div class="contact-grid">

                <!-- ========== CONTACT DETAILS (LEFT COLUMN) ========== -->
                <div class="contact-details-card">
                    <h3>Contact Information</h3>
                    <p>Reach out to us through any of the following channels. We look forward to hearing from you!</p>

                    <div class="contact-item">
                        <i class="fa-solid fa-map-marker-alt"></i>
                        <div>
                            <strong>Our Office</strong>
                            <span>AL Quresh Near Railway Pahatak,  Infront of Al Quresh Housing Scheme Sher Shah Road Multan</span>
                        </div>
                    </div>

                    <div class="contact-item">
                        <i class="fa-solid fa-envelope"></i>
                        <div>
                            <strong>Email Us</strong>
                            <a href="mailto:rftravelsandtours@gmail.com">
                                rftravelsandtours@gmail.com</a>
                        </div>
                    </div>

                    <div class="contact-item">
                        <i class="fa-solid fa-phone"></i>
                        <div>
                            <strong>Call Us</strong>
                            <a href="tel:923052394810">0305 2394810</a>
                            <a href="tel:923219657544">0321 9657544
                            </a>
                        </div>
                    </div>

                    <div class="social-links">
                        <a href="#" aria-label="Facebook"><i class="fa-brands fa-facebook-f"></i></a>
                        <a href="#" aria-label="Instagram"><i class="fa-brands fa-instagram"></i></a>
                        <a href="https://wa.me/923052394810" aria-label="WhatsApp"><i class="fa-brands fa-whatsapp"></i></a>
                    </div>
                </div>

                <!-- ========== CONTACT FORM (RIGHT COLUMN) ========== -->
                <div class="contact-form-card">
                    <h3>Send Us a Message</h3>
                    <form class="contact-page-form" action="#" method="POST">
                        <div class="form-row">
                            <div class="form-group">
                                <label for="name">Full Name</label>
                                <input type="text" id="name" name="name" required>
                            </div>
                            <div class="form-group">
                                <label for="email">Email Address</label>
                                <input type="email" id="email" name="email" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="subject">Subject</label>
                            <input type="text" id="subject" name="subject" required>
                        </div>
                        <div class="form-group">
                            <label for="message">Your Message</label>
                            <textarea id="message" name="message" rows="5" required></textarea>
                        </div>
                        <div class="form-footer">
                            <button type="submit" class="btn-primary">Send Message</button>
                        </div>
                    </form>
                </div>

            </div>

            <!-- ========== MAP SECTION ========== -->
            <div class="map-section">
                <h3>Our Location</h3>
                <!-- IMPORTANT: Go to Google Maps, find your address, click Share -> Embed a map, and paste your iframe code here. -->
                <div class="map-embed">
                    <iframe
                        src="https://www.openstreetmap.org/export/embed.html?bbox=71.3800%2C30.1400%2C71.3940%2C30.1500&layer=mapnik&marker=30.14478%2C71.38708"
                        width="600"
                        height="450"
                        style="border:0;"
                        allowfullscreen=""
                        loading="lazy"
                        referrerpolicy="no-referrer-when-downgrade">
                    </iframe>
                </div>

            </div>
        </div>
    </main>
    <?php include 'floating-icon.php'; ?>

    <?php include 'footer.php'; ?>

</body>

</html>