<?php
// This is a temporary debug file. It is safe to delete after we solve the problem.
header('Content-Type: text/plain'); // Set content type to plain text for easy reading

echo "--- Server Path Diagnostics --- \n\n";

// 1. Get the Document Root as the server sees it.
$document_root = $_SERVER['DOCUMENT_ROOT'];
echo "DOCUMENT_ROOT reported by server: " . $document_root . "\n\n";

// 2. Construct the full path to the assets directory.
$assets_path = $document_root . '/images/post-assets/';
echo "Attempting to use this full path for images: " . $assets_path . "\n\n";

// 3. List the files we need to check.
$files_to_check = [
    'background.jpg',
    'logo.png',
    'kaaba.jpg',
    'nabawi.jpg',
    'another.jpg',
    'whatsapp.png'
];

echo "--- Checking Individual Files --- \n";

foreach ($files_to_check as $file) {
    $full_file_path = $assets_path . $file;
    echo "\nChecking for: " . $full_file_path . "\n";
    
    // Check if the file exists at that path
    if (file_exists($full_file_path)) {
        echo "   -> RESULT: FOUND! \n";
        // Also check if the file is readable by the script
        if (is_readable($full_file_path)) {
            echo "   -> PERMISSIONS: OK (File is readable).\n";
        } else {
            echo "   -> PERMISSIONS: ERROR! (File exists but is NOT readable).\n";
        }
    } else {
        echo "   -> RESULT: NOT FOUND! \n";
    }
}

echo "\n--- End of Report ---";

?>