<?php
// fetch-booking-details.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
header('Content-Type: application/json');
include_once 'db-config.php';

$response = ['success' => false, 'message' => 'An unknown error occurred.'];

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['booking_ref'])) {
    $booking_ref = trim($_POST['booking_ref']);

    if (empty($booking_ref)) {
        $response['message'] = 'Booking reference cannot be empty.';
        echo json_encode($response);
        exit();
    }

    try {
        $stmt = $conn->prepare("SELECT passenger_details, total_price FROM bookings WHERE booking_ref = ?");
        if ($stmt === false) {
            throw new Exception("Database prepare failed: " . $conn->error);
        }
        
        $stmt->bind_param("s", $booking_ref);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $booking = $result->fetch_assoc();
            $passenger_data = json_decode($booking['passenger_details'], true);

            // Check if JSON decoding was successful
            if (json_last_error() === JSON_ERROR_NONE && is_array($passenger_data)) {
                $adults = isset($passenger_data['adults']) ? count($passenger_data['adults']) : 0;
                $children = isset($passenger_data['children']) ? count($passenger_data['children']) : 0;
                $infants = isset($passenger_data['infants']) ? count($passenger_data['infants']) : 0;

                $response = [
                    'success' => true,
                    'pax' => [
                        'adults' => $adults,
                        'children' => $children,
                        'infants' => $infants
                    ],
                    'total_ticket_price' => $booking['total_price']
                ];

            } else {
                $response['message'] = 'Could not read passenger details for this booking. Please contact support.';
            }
        } else {
            $response['message'] = 'No flight booking found with this reference. Please check the reference and try again.';
        }
        $stmt->close();

    } catch (Exception $e) {
        $response['message'] = "Server error: " . $e->getMessage();
        http_response_code(500);
    }

} else {
    $response['message'] = 'Invalid request method.';
}

echo json_encode($response);
$conn->close();
?>