<?php
// flight-search.php

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
include 'db-config.php';

// --- PRODUCTION API KEYS ---
$apiKey = 'ODHfAdal8JCJrcFC8NGrbSnAVmCS3hMC';
$apiSecret = '2VHNu0uaCSiGDsT4';

// --- Helper Functions ---
function getAccessToken($key, $secret) {
    if (isset($_SESSION['amadeus_prod_token']) && time() < $_SESSION['amadeus_prod_token_expires']) {
        return $_SESSION['amadeus_prod_token'];
    }
    $url = 'https://api.amadeus.com/v1/security/oauth2/token';
    $data = http_build_query(['grant_type' => 'client_credentials', 'client_id' => $key, 'client_secret' => $secret]);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt_array($ch, [CURLOPT_URL => $url, CURLOPT_POST => 1, CURLOPT_POSTFIELDS => $data, CURLOPT_RETURNTRANSFER => true, CURLOPT_HTTPHEADER => ['Content-Type: application/x-www-form-urlencoded']]);
    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        curl_close($ch);
        return null;
    }
    curl_close($ch);
    $responseData = json_decode($response, true);
    if (isset($responseData['access_token'])) {
        $_SESSION['amadeus_prod_token'] = $responseData['access_token'];
        $_SESSION['amadeus_prod_token_expires'] = time() + ($responseData['expires_in'] - 300);
        return $responseData['access_token'];
    }
    return null;
}

function processItinerary($itinerary, $dictionaries) {
    $firstSegment = $itinerary['segments'][0];
    $lastSegment = end($itinerary['segments']);
    $airlineCode = $firstSegment['carrierCode'];
    return [
        'departureTime' => date('H:i', strtotime($firstSegment['departure']['at'])),
        'departureTimestamp' => strtotime($firstSegment['departure']['at']),
        'arrivalTimestamp' => strtotime($lastSegment['arrival']['at']),
        'departureDate' => date('D, M j', strtotime($firstSegment['departure']['at'])),
        'arrivalTime' => date('H:i', strtotime($lastSegment['arrival']['at'])),
        'arrivalDate' => date('D, M j', strtotime($lastSegment['arrival']['at'])),
        'origin' => $firstSegment['departure']['iataCode'],
        'destination' => $lastSegment['arrival']['iataCode'],
        'duration' => $itinerary['duration'],
        'stops' => count($itinerary['segments']) - 1,
        'airlineName' => $dictionaries['carriers'][$airlineCode] ?? $airlineCode,
        'airlineLogo' => 'https://daisycon.io/images/airline/?width=150&height=150&iata=' . $airlineCode,
        'flightNumber' => $airlineCode . '-' . $firstSegment['number']
    ];
}

function getSegments($itinerary, $dictionaries) {
    $segmentsDetails = [];
    foreach ($itinerary['segments'] as $index => $segment) {
        $carrierCode = $segment['carrierCode'];
        $details = [
            'airlineName' => $dictionaries['carriers'][$carrierCode] ?? $carrierCode,
            'airlineLogo' => 'https://daisycon.io/images/airline/?width=150&height=150&iata=' . $carrierCode,
            'flightNumber' => $carrierCode . '-' . $segment['number'],
            'departure' => ['iata' => $segment['departure']['iataCode'], 'terminal' => $segment['departure']['terminal'] ?? null, 'time' => date('h:i A', strtotime($segment['departure']['at'])), 'date' => date('D, M j', strtotime($segment['departure']['at']))],
            'arrival' => ['iata' => $segment['arrival']['iataCode'], 'terminal' => $segment['arrival']['terminal'] ?? null, 'time' => date('h:i A', strtotime($segment['arrival']['at'])), 'date' => date('D, M j', strtotime($segment['arrival']['at']))],
            'duration' => str_replace(['PT', 'H', 'M'], ['', 'h ', 'm'], $segment['duration'])
        ];
        if (isset($itinerary['segments'][$index + 1])) {
            $layoverStart = new DateTime($segment['arrival']['at']);
            $layoverEnd = new DateTime($itinerary['segments'][$index + 1]['departure']['at']);
            $layover = $layoverStart->diff($layoverEnd);
            $details['layover'] = ['duration' => $layover->format('%hh %im'), 'airport' => $segment['arrival']['iataCode']];
        }
        $segmentsDetails[] = $details;
    }
    return $segmentsDetails;
}

function getLowestFareForDate($accessToken, $queryParams) {
    $queryParams['max'] = 1; // We only need the cheapest flight
    $searchUrl = 'https://api.amadeus.com/v2/shopping/flight-offers?' . http_build_query($queryParams);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt_array($ch, [CURLOPT_URL => $searchUrl, CURLOPT_RETURNTRANSFER => true, CURLOPT_HTTPHEADER => ['Authorization: Bearer ' . $accessToken]]);
    $response = curl_exec($ch);
    curl_close($ch);
    $data = json_decode($response, true);
    if (isset($data['data'][0]['price']['total'])) {
        return (float)$data['data'][0]['price']['total'] + 1500; // Add service fee
    }
    return null;
}

// --- SCRIPT EXECUTION STARTS HERE ---
$legs = $_GET['legs'] ?? [];
$tripType = $_GET['tripType'] ?? 'one-way';
$returnDate = $_GET['returnDate'] ?? '';
$processedFlights = [];
$apiError = null;

$origin = $legs[0]['origin'] ?? '';
$destination = $legs[0]['destination'] ?? '';
$departureDate = $legs[0]['date'] ?? '';

$adults_count = intval($_GET['adults'] ?? 1);
$children_count = intval($_GET['children'] ?? 0);
$infants_count = intval($_GET['infants'] ?? 0);
$travelClass_raw = $_GET['travelClass'] ?? 'Economy';
$is_package_flow = isset($_GET['service_redirect']) && $_GET['service_redirect'] === 'custom_package';


$prev_day_price = null;
$next_day_price = null;
$minPrice = 0;
$maxPrice = 0;
$airlines = [];

if (!empty($origin) && !empty($destination) && !empty($departureDate)) {
    $_SESSION['flight_search_params'] = $_GET;
    $accessToken = getAccessToken($apiKey, $apiSecret);
    if ($accessToken) {
        $travelClass_map = ['Economy' => 'ECONOMY', 'Premium Economy' => 'PREMIUM_ECONOMY', 'Business' => 'BUSINESS', 'First' => 'FIRST'];
        $travelClass = $travelClass_map[$travelClass_raw] ?? 'ECONOMY';
        
        $mainQueryParams = [
            'originLocationCode' => $origin,
            'destinationLocationCode' => $destination,
            'departureDate' => $departureDate,
            'adults' => $adults_count,
            'children' => $children_count,
            'infants' => $infants_count,
            'max' => 50,
            'currencyCode' => 'PKR',
            'travelClass' => $travelClass
        ];
        if ($tripType === 'return' && !empty($returnDate)) {
            $mainQueryParams['returnDate'] = $returnDate;
        }

        $searchUrl = 'https://api.amadeus.com/v2/shopping/flight-offers?' . http_build_query($mainQueryParams);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt_array($ch, [CURLOPT_URL => $searchUrl, CURLOPT_RETURNTRANSFER => true, CURLOPT_HTTPHEADER => ['Authorization: Bearer ' . $accessToken]]);
        $apiResponse = curl_exec($ch);
        curl_close($ch);
        $flightOffersData = json_decode($apiResponse, true);

        if (isset($flightOffersData['data']) && !empty($flightOffersData['data'])) {
            $dictionaries = $flightOffersData['dictionaries'];
            $prices = [];
            foreach ($flightOffersData['data'] as $flight) {
                $service_fee = 1500;
                $finalPrice = (float)$flight['price']['total'] + $service_fee;
                $prices[] = $finalPrice;
                $processedItinerary = processItinerary($flight['itineraries'][0], $dictionaries);
                $airlines[$processedItinerary['airlineName']] = true;
                $baggage = "Not Specified";
                if (isset($flight['travelerPricings'][0]['fareDetailsBySegment'][0]['includedCheckedBags']['quantity'])) {
                    $baggage = $flight['travelerPricings'][0]['fareDetailsBySegment'][0]['includedCheckedBags']['quantity'] . " Pc(s)";
                }
                $processedFlight = ['price' => $finalPrice, 'currency' => $flight['price']['currency'], 'refundable' => $flight['pricingOptions']['refundableFare'] ?? false, 'baggage' => $baggage, 'itineraries' => []];
                foreach ($flight['itineraries'] as $itinerary) {
                    $itineraryData = processItinerary($itinerary, $dictionaries);
                    $itineraryData['segments'] = getSegments($itinerary, $dictionaries);
                    $processedFlight['itineraries'][] = $itineraryData;
                }
                $processedFlights[] = $processedFlight;
            }
            $_SESSION['flight_search_results'] = $processedFlights;
            ksort($airlines);
            $minPrice = !empty($prices) ? floor(min($prices)) : 0;
            $maxPrice = !empty($prices) ? ceil(max($prices)) : 0;

            // Fetch prices for adjacent dates
            $current_date_obj = new DateTime($departureDate, new DateTimeZone('UTC'));
            $adjQueryParams = $mainQueryParams;
            
            $adjQueryParams['departureDate'] = (clone $current_date_obj)->modify('-1 day')->format('Y-m-d');
            $prev_day_price = getLowestFareForDate($accessToken, $adjQueryParams);
            
            $adjQueryParams['departureDate'] = (clone $current_date_obj)->modify('+1 day')->format('Y-m-d');
            $next_day_price = getLowestFareForDate($accessToken, $adjQueryParams);

        } else {
            $apiError = $flightOffersData['errors'][0]['detail'] ?? 'No flight offers found for the selected route and date.';
        }
    } else {
        $apiError = "Could not connect to the flight search service.";
    }
} else {
    $apiError = "Please provide a valid origin, destination, and date to start your search.";
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Flights from <?php echo htmlspecialchars($origin) . " to " . htmlspecialchars($destination); ?> - RF Travel & Tours</title>
    <link rel="icon" type="image/png" href="images/logo-icon.png">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/noUiSlider/15.7.1/nouislider.min.css">
    <style>
        body { background-color: #f8f9fa; }
        .search-results-container { max-width: 1400px; margin: 2rem auto; padding: 0 1rem; }
        .results-page-header { background: #1a2a4d; padding: 2rem 0; text-align: center; color: #fff; margin-bottom: 2rem; }
        .animated-route-display { font-size: 2.5rem; font-weight: 700; }
        .animated-route-display .fa-plane { margin: 0 2rem; }

        .sidebar-overlay { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 999; display: none; opacity: 0; transition: opacity 0.3s ease; }
        .sidebar-overlay.is-visible { display: block; opacity: 1; }
        #mobile-filter-btn { display: none; }
        .filters-sidebar .close-sidebar-btn { display: none; }

        .results-layout { display: grid; grid-template-columns: 300px 1fr; gap: 2rem; align-items: flex-start; }
        .filters-sidebar { background: #fff; border-radius: 12px; padding: 1.5rem; box-shadow: 0 4px 15px rgba(0,0,0,0.07); height: fit-content; position: sticky; top: 20px; }
        .filter-group { border-bottom: 1px solid #e9ecef; padding-bottom: 1.5rem; margin-bottom: 1.5rem; }
        .filter-group:last-child { border-bottom: none; margin-bottom: 0; padding-bottom: 0; }
        .filter-group h4 { margin-top: 0; margin-bottom: 1rem; font-size: 1.1rem; color: #343a40; display: flex; justify-content: space-between; align-items: center; }
        .filter-group a.clear-filter { font-size: 0.8rem; font-weight: 500; color: #12a7ee; text-decoration: none; cursor: pointer; }
        .filter-option { margin-bottom: 0.5rem; }
        .filter-option label { display: flex; align-items: center; gap: 0.75rem; font-size: 0.95rem; cursor: pointer; }
        .price-slider-values { display: flex; justify-content: space-between; font-size: 0.9rem; font-weight: 500; margin-top: 1rem; }
        #price-slider { margin: 1.5rem 0.5rem 0 0.5rem; }
        .noUi-connect { background: #12a7ee; }
        .date-strip { display: flex; justify-content: space-between; align-items: center; background: #fff; border-radius: 8px; padding: 0.5rem 1rem; margin-bottom: 1.5rem; box-shadow: 0 2px 8px rgba(0,0,0,0.06); }
        .date-strip a, .date-strip span { padding: 0.5rem 1rem; text-decoration: none; color: #495057; font-weight: 500; border-radius: 6px; text-align: center; }
        .date-strip a:hover { background: #f1f3f5; }
        .date-strip .current-date { background: #e9f5fd; color: #12a7ee; }
        .date-strip .date-price { font-size: 0.8em; color: #28a745; font-weight: 600; display: block; }
        .sorting-tabs { display: flex; gap: 0.5rem; margin-bottom: 1.5rem; }
        .sorting-tabs button { background: #fff; border: 1px solid #ced4da; border-radius: 20px; padding: 0.5rem 1.25rem; cursor: pointer; font-weight: 500; transition: all 0.2s; }
        .sorting-tabs button.active { background: #12a7ee; color: #fff; border-color: #12a7ee; }
        .flight-row-wrapper { margin-bottom: 1rem; background: #fff; border-radius: 12px; box-shadow: 0 2px 8px rgba(0,0,0,0.06); transition: box-shadow 0.2s; }
        .flight-row-wrapper:hover { box-shadow: 0 4px 15px rgba(0,0,0,0.1); }
        .flight-row-footer { border-top: 1px solid #f1f3f5; }
        .flight-row-details-content { max-height: 0; overflow: hidden; transition: max-height 0.4s ease-in-out; }
        .detailed-segment { display: flex; gap: 1rem; align-items: flex-start; padding: 1rem 1.5rem; border-bottom: 1px dashed #e9ecef; }
        .detailed-segment:last-child { border-bottom: none; }
        .segment-info { flex-shrink: 0; display: flex; align-items: center; gap: 10px; width: 200px; }
        .segment-info img { width: 40px; height: 40px; border-radius: 5px; }
        .segment-info div { display: flex; flex-direction: column; }
        .segment-info strong { font-size: 0.9rem; color: #343a40; }
        .segment-info small { font-size: 0.8rem; color: #6c757d; }
        .detailed-timing { display: flex; align-items: center; justify-content: space-between; flex-grow: 1; gap: 1rem; }
        .detailed-timing p { margin: 0; font-size: 0.9rem; color: #495057; }
        .detailed-timing p strong { font-size: 1rem; font-weight: 600; color: #212529; }
        .detailed-timing .duration-leg { text-align: center; color: #6c757d; }
        .detailed-layover { background: #f8f9fa; text-align: center; padding: 0.75rem; font-weight: 500; color: #495057; font-size: 0.9rem; }
        .detailed-layover i { color: #fd7e14; }

        @media (max-width: 992px) {
            #mobile-filter-btn { display: block; margin-bottom: 1.5rem; width: 100%; background: #fff; border: 1px solid #ced4da; border-radius: 8px; padding: 0.75rem; font-size: 1rem; font-weight: 600; text-align: left; box-shadow: 0 2px 8px rgba(0,0,0,0.06); cursor: pointer; }
            .results-layout { grid-template-columns: 1fr; }
            .filters-sidebar { position: fixed; top: 0; left: -320px; width: 320px; height: 100%; z-index: 1000; transition: left 0.3s ease-in-out; overflow-y: auto; border-radius: 0; box-shadow: 0 0 20px rgba(0,0,0,0.2); top: 0; }
            .filters-sidebar.is-open { left: 0; }
            .filters-sidebar .close-sidebar-btn { display: block; position: absolute; top: 1rem; right: 1rem; background: none; border: none; font-size: 1.5rem; cursor: pointer; color: #6c757d; }
        }
        @media (max-width: 768px) {
            .animated-route-display { font-size: 1.8rem; }
            .detailed-timing { flex-direction: column; align-items: flex-start; gap: 0.5rem; }
        }
    </style>
</head>
<body>
    <?php include 'header.php'; ?>

    <div class="sidebar-overlay"></div>

    <section class="results-page-header">
        <div class="container">
            <div class="animated-route-display">
                <span class="route-iata"><?php echo htmlspecialchars($origin); ?></span>
                <div class="route-animation-path"><i class="fa-solid fa-plane"></i></div>
                <span class="route-iata"><?php echo htmlspecialchars($destination); ?></span>
            </div>
        </div>
    </section>

    <div class="search-results-container">
        <button id="mobile-filter-btn"><i class="fa-solid fa-filter"></i> Show Filters</button>

        <div class="results-layout">
            <aside class="filters-sidebar" id="filters-sidebar">
                <button class="close-sidebar-btn" id="close-sidebar-btn">&times;</button>
                <div class="filter-group">
                    <h4>Stops <a href="#" class="clear-filter" data-filter="stops">Clear</a></h4>
                    <div class="filter-option"><label><input type="checkbox" name="stops" value="0"> Nonstop</label></div>
                    <div class="filter-option"><label><input type="checkbox" name="stops" value="1"> 1 Stop</label></div>
                    <div class="filter-option"><label><input type="checkbox" name="stops" value="2"> 2+ Stops</label></div>
                </div>
                <div class="filter-group">
                    <h4>Airlines <a href="#" class="clear-filter" data-filter="airline">Clear</a></h4>
                    <?php if(!empty($airlines)): ?>
                        <?php foreach($airlines as $name => $val): ?>
                            <div class="filter-option"><label><input type="checkbox" name="airline" value="<?php echo htmlspecialchars($name); ?>"> <?php echo htmlspecialchars($name); ?></label></div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
                <?php if ($minPrice > 0 && $maxPrice > $minPrice): ?>
                <div class="filter-group">
                    <h4>Price Range</h4>
                    <div id="price-slider"></div>
                    <div class="price-slider-values">
                        <span id="price-lower">PKR 0</span>
                        <span id="price-upper">PKR 0</span>
                    </div>
                </div>
                <?php endif; ?>
            </aside>
            <main class="results-content">
                <?php if (!empty($processedFlights)): ?>
                    <div class="date-strip">
                        <?php 
                            $current_date_obj = new DateTime($departureDate, new DateTimeZone('UTC'));
                            $params = $_GET;
                            
                            $params['legs'][0]['date'] = (clone $current_date_obj)->modify('-1 day')->format('Y-m-d');
                            $prev_day_url = 'flight-search.php?' . http_build_query($params);
                            
                            $params['legs'][0]['date'] = (clone $current_date_obj)->modify('+1 day')->format('Y-m-d');
                            $next_day_url = 'flight-search.php?' . http_build_query($params);
                        ?>
                        <a href="<?php echo $prev_day_url; ?>">
                            &lt; <?php echo (clone $current_date_obj)->modify('-1 day')->format('D, M j'); ?>
                            <?php if($prev_day_price): ?>
                                <span class="date-price">from <?= number_format($prev_day_price) ?></span>
                            <?php endif; ?>
                        </a>
                        <span class="current-date">
                            <?php echo $current_date_obj->format('D, M j, Y'); ?>
                            <span class="date-price">from <?= number_format($minPrice) ?></span>
                        </span>
                        <a href="<?php echo $next_day_url; ?>">
                            <?php echo (clone $current_date_obj)->modify('+1 day')->format('D, M j'); ?> &gt;
                            <?php if($next_day_price): ?>
                                <span class="date-price">from <?= number_format($next_day_price) ?></span>
                            <?php endif; ?>
                        </a>
                    </div>
                    <div class="sorting-tabs">
                        <button class="active" data-sort="price">Cheapest</button>
                        <button data-sort="duration">Fastest</button>
                    </div>
                    <div class="results-list">
                        <?php foreach ($processedFlights as $index => $flight): ?>
                            <?php $itinerary = $flight['itineraries'][0]; ?>
                            <div class="flight-row-wrapper" 
                                 data-price="<?php echo $flight['price']; ?>"
                                 data-stops="<?php echo $itinerary['stops']; ?>"
                                 data-airline="<?php echo htmlspecialchars($itinerary['airlineName']); ?>"
                                 data-departure-ts="<?php echo $itinerary['departureTimestamp']; ?>"
                                 data-duration="<?php echo ($itinerary['arrivalTimestamp'] - $itinerary['departureTimestamp']); ?>"
                                 >
                                <div class="flight-row-main">
                                    <div class="itinerary-part">
                                        <div class="airline-details"><img src="<?php echo htmlspecialchars($itinerary['airlineLogo']); ?>" alt=""><div class="airline-name-info"><span><?php echo htmlspecialchars($itinerary['airlineName']); ?></span><small><?php echo htmlspecialchars($itinerary['flightNumber']); ?></small></div></div>
                                        <div class="flight-timing-details">
                                            <div class="time-iata"><strong><?php echo date('h:i A', strtotime($itinerary['departureTime'])); ?></strong><span><?php echo htmlspecialchars($itinerary['origin']); ?></span></div>
                                            <div class="duration-stops"><span class="total-duration"><?php echo str_replace(['PT', 'H', 'M'], ['', 'h ', 'm'], $itinerary['duration']); ?></span><div class="line"></div><span class="stop-link"><?php echo $itinerary['stops'] > 0 ? $itinerary['stops'] . ' Stop(s)' : 'Nonstop'; ?></span></div>
                                            <div class="time-iata"><strong><?php echo date('h:i A', strtotime($itinerary['arrivalTime'])); ?></strong><span><?php echo htmlspecialchars($itinerary['destination']); ?></span></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flight-row-footer">
                                    <div class="flight-meta-details"><span><i class="fa-solid fa-suitcase"></i> <?php echo htmlspecialchars($flight['baggage']); ?></span></div>
                                    <div class="price-quote-details">
                                        <a href="checkout.php?flight_id=<?php echo $index; ?>" class="btn-get-quote with-price">
                                            <?php if ($is_package_flow): ?>
                                                <small>From</small><strong>PKR <?php echo number_format($flight['price'], 0); ?></strong><span>Select & Build Package</span>
                                            <?php else: ?>
                                                <small>Book From</small><strong><?php echo htmlspecialchars($flight['currency']); ?> <?php echo number_format($flight['price'], 0); ?></strong>
                                            <?php endif; ?>
                                        </a>
                                        <button type="button" class="btn-flight-details">Details <i class="fa-solid fa-chevron-down"></i></button>
                                    </div>
                                </div>
                                <div class="flight-row-details-content">
                                    <?php foreach ($flight['itineraries'] as $itinerary_index => $itinerary_detail): ?>
                                        <h4 style="padding: 1rem 1.5rem 0; margin:0;"><?php echo $tripType === 'return' ? ($itinerary_index === 0 ? 'Outbound' : 'Return') : 'Flight'; ?> Details (<?php echo htmlspecialchars($itinerary_detail['origin'] . ' to ' . $itinerary_detail['destination']); ?>)</h4>
                                        <?php foreach ($itinerary_detail['segments'] as $segment): ?>
                                            <div class="detailed-segment">
                                                <div class="segment-info">
                                                    <img src="<?php echo htmlspecialchars($segment['airlineLogo']); ?>">
                                                    <div><strong><?php echo htmlspecialchars($segment['airlineName']); ?></strong><small><?php echo htmlspecialchars($segment['flightNumber']); ?></small></div>
                                                </div>
                                                <div class="detailed-timing">
                                                    <p><strong><?php echo htmlspecialchars($segment['departure']['time']); ?></strong><br><?php echo htmlspecialchars($segment['departure']['iata']); ?></p>
                                                    <p class="duration-leg"><i class="fa-solid fa-clock"></i><br><?php echo htmlspecialchars($segment['duration']); ?></p>
                                                    <p><strong><?php echo htmlspecialchars($segment['arrival']['time']); ?></strong><br><?php echo htmlspecialchars($segment['arrival']['iata']); ?></p>
                                                </div>
                                            </div>
                                            <?php if (isset($segment['layover'])): ?>
                                                <div class="detailed-layover"><i class="fa-solid fa-hourglass-half"></i> Layover of <?php echo htmlspecialchars($segment['layover']['duration']); ?> in <?php echo htmlspecialchars($segment['layover']['airport']); ?></div>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <div class="no-results-card">
                        <h3>No Flights Found</h3>
                        <p><?php echo htmlspecialchars($apiError); ?></p>
                        <a href="index.php" class="btn-back">Go Back to Search</a>
                    </div>
                <?php endif; ?>
            </main>
        </div>
    </div>
    
    <?php include 'footer.php'; ?>
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/noUiSlider/15.7.1/nouislider.min.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        document.querySelectorAll('.btn-flight-details').forEach(button => {
            button.addEventListener('click', function() {
                const wrapper = this.closest('.flight-row-wrapper');
                const content = wrapper.querySelector('.flight-row-details-content');
                const icon = this.querySelector('i');
                const isActive = content.style.maxHeight;
                if (isActive && isActive !== '0px') {
                    content.style.maxHeight = null;
                    icon.style.transform = 'rotate(0deg)';
                } else {
                    content.style.maxHeight = content.scrollHeight + "px";
                    icon.style.transform = 'rotate(180deg)';
                }
            });
        });

        const priceSlider = document.getElementById('price-slider');
        const minPrice = <?php echo $minPrice ?? 0; ?>;
        const maxPrice = <?php echo $maxPrice ?? 0; ?>;
        if (priceSlider && minPrice < maxPrice) {
            noUiSlider.create(priceSlider, {
                start: [minPrice, maxPrice],
                connect: true,
                range: { 'min': minPrice, 'max': maxPrice },
                step: 100,
                format: { to: v => Math.round(v), from: v => Number(v) }
            });
            const priceLower = document.getElementById('price-lower');
            const priceUpper = document.getElementById('price-upper');
            priceSlider.noUiSlider.on('update', function(values) {
                priceLower.innerHTML = 'PKR ' + values[0].toLocaleString();
                priceUpper.innerHTML = 'PKR ' + values[1].toLocaleString();
            });
            priceSlider.noUiSlider.on('change', applyFilters);
        }

        const filters = document.querySelectorAll('.filters-sidebar input[type="checkbox"]');
        filters.forEach(filter => filter.addEventListener('change', applyFilters));
        
        document.querySelectorAll('.clear-filter').forEach(btn => {
            btn.addEventListener('click', e => {
                e.preventDefault();
                document.querySelectorAll(`input[name="${btn.dataset.filter}"]:checked`).forEach(c => c.checked = false);
                applyFilters();
            });
        });

        function applyFilters() {
            const stopFilters = Array.from(document.querySelectorAll('input[name="stops"]:checked')).map(el => el.value);
            const airlineFilters = Array.from(document.querySelectorAll('input[name="airline"]:checked')).map(el => el.value);
            const priceRange = priceSlider ? priceSlider.noUiSlider.get() : [minPrice, maxPrice];

            document.querySelectorAll('.flight-row-wrapper').forEach(flight => {
                const price = parseFloat(flight.dataset.price);
                const stops = flight.dataset.stops;
                const airline = flight.dataset.airline;

                const priceMatch = price >= priceRange[0] && price <= priceRange[1];
                const stopMatch = stopFilters.length === 0 || stopFilters.includes(stops) || (stops >= 2 && stopFilters.includes('2'));
                const airlineMatch = airlineFilters.length === 0 || airlineFilters.includes(airline);
                
                flight.style.display = (priceMatch && stopMatch && airlineMatch) ? '' : 'none';
            });
        }
        
        const sortButtons = document.querySelectorAll('.sorting-tabs button');
        const resultsList = document.querySelector('.results-list');
        sortButtons.forEach(button => {
            button.addEventListener('click', () => {
                sortButtons.forEach(btn => btn.classList.remove('active'));
                button.classList.add('active');
                sortFlights(button.dataset.sort);
            });
        });

        function sortFlights(criteria) {
            const flights = Array.from(resultsList.querySelectorAll('.flight-row-wrapper'));
            flights.sort((a, b) => {
                if (criteria === 'price') return parseFloat(a.dataset.price) - parseFloat(b.dataset.price);
                if (criteria === 'duration') return parseFloat(a.dataset.duration) - parseFloat(b.dataset.duration);
                return 0;
            });
            flights.forEach(flight => resultsList.appendChild(flight));
        }
        sortFlights('price');

        const mobileFilterBtn = document.getElementById('mobile-filter-btn');
        const sidebar = document.getElementById('filters-sidebar');
        const overlay = document.querySelector('.sidebar-overlay');
        const closeBtn = document.getElementById('close-sidebar-btn');
        
        const openSidebar = () => { sidebar.classList.add('is-open'); overlay.classList.add('is-visible'); };
        const closeSidebar = () => { sidebar.classList.remove('is-open'); overlay.classList.remove('is-visible'); };

        if(mobileFilterBtn) mobileFilterBtn.addEventListener('click', openSidebar);
        if(overlay) overlay.addEventListener('click', closeSidebar);
        if(closeBtn) closeBtn.addEventListener('click', closeSidebar);
    });
    </script>
</body>
</html>