<?php
// We need to start the session on any page that includes the header
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Determine the correct account page URL based on user type
$account_page_url = 'my-account.php'; // Default for customers
if (isset($_SESSION['user_type'])) {
    if ($_SESSION['user_type'] === 'agent') {
        $account_page_url = 'agent-dashboard.php';
    } elseif ($_SESSION['user_type'] === 'admin') {
        $account_page_url = 'admin/dashboard.php';
    }
}
?>

<!-- ======================================================== -->
<!-- === NEW STYLES FOR SIDEBAR HEADER AND AUTH BUTTONS === -->
<!-- ======================================================== -->
<style>
    /* Make the sidebar header a flex container to align items */
    .sidebar-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 1rem 1.5rem;
        border-bottom: 1px solid #f0f0f0;
    }

    /* Container for the logo and the new welcome text */
    .sidebar-user-info {
        display: flex;
        align-items: center;
        gap: 15px; /* Space between logo and text */
    }

    /* Make the logo slightly bigger */
    .sidebar-logo-image {
        height: 55px;
        width: 55px;
        border-radius: 50%;
        object-fit: cover;
    }

    /* Styling for the new welcome text block */
    .sidebar-welcome-text {
        font-family: 'Poppins', sans-serif;
        color: #333;
    }

    .sidebar-welcome-text span {
        display: block;
        font-size: 0.8rem;
        color: #888;
    }
    
    .sidebar-welcome-text .sidebar-username {
        font-weight: 600;
        font-size: 1rem;
        color: #333;
        /* Crucial for the "..." truncation effect */
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        max-width: 150px; /* Adjust this width if needed */
    }

    /* Ensure auth buttons have proper styling */
    .sidebar-auth-buttons {
        padding: 1rem 1.5rem;
    }
    .user-welcome-sidebar .btn-myaccount-sidebar,
    .user-welcome-sidebar .btn-logout-sidebar {
        display: block;
        width: 100%;
        text-align: center;
        padding: 12px;
        border-radius: 25px;
        text-decoration: none;
        font-weight: 600;
        margin-top: 10px;
    }
    .user-welcome-sidebar .btn-myaccount-sidebar {
        background-color: var(--primary-color);
        color: black;
    }
    .user-welcome-sidebar .btn-logout-sidebar {
        background-color: #f0f0f0;
        color: #333;
    }
</style>


<!-- Sidebar for Mobile Navigation -->
<div class="sidebar-overlay"></div>
<nav class="mobile-sidebar">
    <div class="sidebar-header">
        
        <!-- === UPDATED: Logo and Welcome Message Group === -->
        <div class="sidebar-user-info">
            <a href="index.php" class="sidebar-logo-link">
                <img src="images/logo.png" alt="RF Travel & Tours Logo" class="sidebar-logo-image">
            </a>
            <?php if (isset($_SESSION['user_id'])): 
                // Prepare the display name with truncation
                $user_name = htmlspecialchars($_SESSION['user_name']);
                $display_name = $user_name;
                if (mb_strlen($user_name) > 7) {
                    $display_name = mb_substr($user_name, 0, 7) . '...';
                }
            ?>
                <div class="sidebar-welcome-text">
                    <span>Welcome</span>
                    <strong class="sidebar-username"><?php echo $display_name; ?></strong>
                </div>
            <?php endif; ?>
        </div>
        <!-- === END UPDATE === -->

        <button class="sidebar-close-btn"><i class="fa-solid fa-times"></i></button>
    </div>
    <div class="sidebar-content">
        <!-- Service Links -->
        <a href="index.php" class="sidebar-link"><i class="fa-solid fa-plane-up"></i> Tickets</a>
        <a href="group-fares" class="sidebar-link"><i class="fa-solid fa-users"></i> Groups</a>
        <a href="umrah-packages.php" class="sidebar-link"><i class="fa-solid fa-kaaba"></i> Umrah</a>
        <a href="hotels.php" class="sidebar-link"><i class="fa-solid fa-hotel"></i> Hotels</a>
        <a href="visa-services.php" class="sidebar-link"><i class="fa-solid fa-passport"></i> Visas</a>
        
        <hr class="sidebar-divider">
        
        <!-- Contact Info -->
        <div class="sidebar-contact">
            <i class="fa-solid fa-phone"></i>
            <div>
                <span>Call Us</span>
                <a href="tel:923052394810" style="display: block; font-size: 16px; font-weight: bold; color: #6c757d; text-decoration: none;">0305 2394810</a>
                <a href="tel:923099705022" style="display: block; font-size: 16px; font-weight: bold; color: #6c757d; text-decoration: none;">0309 9705022</a>
            </div>
        </div>
        
        <!-- DYNAMIC AUTH SECTION FOR SIDEBAR -->
        <div class="sidebar-auth-buttons">
            <?php 
            // === LOGIC FIX APPLIED HERE ===
            // This now correctly checks if ANY user is logged in.
            if (isset($_SESSION['user_id'])): 
            ?>
                <div class="user-welcome-sidebar">
                    <a href="<?php echo $account_page_url; ?>" class="btn-myaccount-sidebar">My Account</a>
                    <a href="logout.php" class="btn-logout-sidebar">Logout</a>
                </div>
            <?php else: ?>
                <!-- This block now ONLY shows for logged-out users -->
                <a href="login.php" class="btn-login">Login</a>
                <a href="login.php?view=signup" class="btn-signup">SignUp</a>
            <?php endif; ?>
        </div>
    </div>
</nav>
<header class="main-header">
    <div class="header-container">
        <div class="nav-left">
            <button class="menu-toggle"><i class="fa-solid fa-bars"></i></button>
            <a href="index.php" class="logo-link" style="text-decoration: none; color: inherit;">
                <img src="images/logo.png" alt="RF Travel & Tours Logo" style="height: 60px; width: auto;">
            </a>
        </div>

      

        <div class="nav-center">
            <i class="fa-solid fa-kaaba"></i>
            Your Trusted <span>Travel Partner</span>
        </div>

        <div class="nav-right">
            <div class="contact-info" style="display: flex; align-items: center; gap: 10px; font-family: Century Gothic;">
                <i class="fa-solid fa-phone" style="font-size: 18px; color: #6c757d;"></i>
                <div>
                    <span style="display: block; font-size: 14px; color: #666;">Call Us</span>
                    <a href="tel:923052394810" style="display: block; font-size: 16px; font-weight: bold; color: #6c757d; text-decoration: none;">0305 2394810</a>
                    <a href="tel:923099705022" style="display: block; font-size: 16px; font-weight: bold; color: #6c757d; text-decoration: none;">0309 9705022</a>
                </div>
            </div>

            <!-- DYNAMIC AUTH SECTION FOR HEADER (Desktop) -->
            <div class="header-auth">
                <?php if (isset($_SESSION['user_id'])): // Show dropdown for ALL logged-in users 
                ?>
                    <div class="user-dropdown-container">
                        <a href="#" class="user-dropdown-toggle">
                            <i class="fa-regular fa-circle-user"></i>
                            <span class="welcome-text"><?php echo htmlspecialchars($_SESSION['user_name']); ?></span>
                            <i class="fa-solid fa-angle-down"></i>
                        </a>
                        <div class="user-dropdown-menu">
                            <a href="<?php echo $account_page_url; ?>" class="dropdown-link">
                                <i class="fa-solid fa-user-gear"></i> My Account
                            </a>
                            <a href="logout.php" class="dropdown-link dropdown-logout-link">
                                <i class="fa-solid fa-arrow-right-from-bracket"></i> Logout
                            </a>
                        </div>
                    </div>
                <?php else: ?>
                    <!-- Show login/signup if user is logged out -->
                    <a href="login.php" class="btn-login">Login</a>
                    <a href="login.php?view=signup" class="btn-signup">SignUp</a>
                <?php endif; ?>
            </div>
        </div>
    </div>


</header>
  <!-- NEW: JavaScript for Sidebar Functionality -->
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const menuToggle = document.querySelector('.menu-toggle');
            const sidebarCloseBtn = document.querySelector('.sidebar-close-btn');
            const mobileSidebar = document.querySelector('.mobile-sidebar');
            const sidebarOverlay = document.querySelector('.sidebar-overlay');
            const body = document.body;

            function openSidebar() {
                mobileSidebar.classList.add('active');
                sidebarOverlay.classList.add('active');
                body.classList.add('sidebar-open');
            }

            function closeSidebar() {
                mobileSidebar.classList.remove('active');
                sidebarOverlay.classList.remove('active');
                body.classList.remove('sidebar-open');
            }

            menuToggle.addEventListener('click', openSidebar);
            sidebarCloseBtn.addEventListener('click', closeSidebar);
            sidebarOverlay.addEventListener('click', closeSidebar);
        });
    </script>