<?php
// This page uses the classic page layout but with the new flyer-style hotel display.
include 'db-config.php';

// --- 1. Fetch data from the NEW package tables ---
$visa_rates_result = $conn->query("SELECT * FROM visa_package_rates WHERE id = 1");
$visa_rates = $visa_rates_result->fetch_assoc();

$makkah_hotels = [];
$madinah_hotels = [];
// MODIFIED: Changed ORDER BY to sort by quad_rate from lowest to highest.
$hotels_result = $conn->query("SELECT * FROM package_hotels ORDER BY quad_rate ASC");

if ($hotels_result && $hotels_result->num_rows > 0) {
    while ($hotel = $hotels_result->fetch_assoc()) {
        if (strtolower($hotel['city']) === 'makkah') {
            $makkah_hotels[] = $hotel;
        } elseif (strtolower($hotel['city']) === 'madinah') {
            $madinah_hotels[] = $hotel;
        }
    }
}

// Helper function to render star ratings
function render_stars($count)
{
    return str_repeat('★', (int)$count);
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Umrah Package Rates - RF Travel & Tours</title>
    <link rel="icon" type="image/png" href="images/logo-icon.png">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Luckiest+Guy&family=Oswald:wght@700&family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <style>
        /* --- Base and Page Layout (FROM ORIGINAL PAGE) --- */
        :root {
            --gold: #31a7e2;
            --header-bg: #000000;
            --cell-bg: #0e0e0e;
            --cell-border: #3c3c3c;
        }

        body {
            margin: 0;
            font-family: 'Poppins', sans-serif;
            background-color: #f0f0f0;
            background-repeat: repeat;
        }

        .page-container {
            padding: 20px;
            max-width: 1200px;
            margin: auto;
        }

        .header-banner img,
        .page-footer img {
            width: 100%;
            display: block;
        }

        .header-banner img {
            border-radius: 8px;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
            margin-bottom: 20px;
        }

        .page-footer {
            margin-top: 40px;
        }

        /* --- Important Note Styling (FROM ORIGINAL PAGE) --- */
        .important-note {
            background-color: #fffbe6;
            border-left: 5px solid #31a7e2;
            padding: 20px;
            margin: 0 auto 30px auto;
            border-radius: 0 8px 8px 0;
            max-width: 95%;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
        }

        .important-note h4 {
            margin: 0 0 10px 0;
            font-size: 1.1rem;
            color: #5d490c;
            display: flex;
            align-items: center;
        }

        .important-note h4 i {
            margin-right: 10px;
            font-size: 1.3rem;
        }

        .important-note p {
            margin: 0;
            font-size: 0.95rem;
            color: #333;
            line-height: 1.6;
        }

        /* --- City Section Styling (FROM ORIGINAL PAGE) --- */
        .city-section {
            margin-top: 20px;
        }

        .city-section-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: #1a1a1a;
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 3px solid #31a7e2;
            padding-bottom: 10px;
            display: inline-block;
        }

        .center-title {
            text-align: center;
        }

        /* =======================================================
   CORRECTED VISA RATES SECTION
   ======================================================= */
        .visa-rates-section {
            display: flex;
            justify-content: space-between;
            /* Pushes items to edges and center */
            align-items: center;
            padding: 15px 10px;
            flex-wrap: nowrap;
            /* CRITICAL: Prevents wrapping on desktop */
        }

        .visa-image {
            flex-shrink: 0;
            /* Prevents images from shrinking */
            width: 100px;
            /* Adjust size as needed */
        }

        .visa-image img {
            max-width: 100%;
            height: auto;
        }

        .rates-group-container {
            display: flex;
            justify-content: center;

            flex-grow: 1;
            /* Allows this container to fill the available space */
        }

        .rate-badge {
            width: 200px;
            height: 120px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center;
            font-family: 'Oswald', sans-serif;
            background-image: url('./images/sphere.png');
            background-size: cover;
            background-repeat: no-repeat;
            background-position: center;
            color: white;
            flex-shrink: 0;
            /* Prevents badges from shrinking */
        }

        .rate-badge .price-line {
            font-size: 1.1rem;
            line-height: 1;
            font-weight: 700;
        }

        .rate-badge .price-line .currency {
            font-family: 'Poppins', sans-serif;
            font-size: 0.8rem;
            color: #ccc;
            margin-left: 2px;
        }

        .rate-badge .group-label {
            font-family: 'Poppins', sans-serif;
            font-size: 0.7rem;
            color: var(--text-light);
            margin-top: 2px;
            letter-spacing: 0.5px;
        }

        /* --- RESPONSIVENESS FOR VISA SECTION --- */
        @media (max-width: 900px) {
            .visa-rates-section {
                flex-wrap: wrap;
                /* Allow wrapping on smaller screens */
                justify-content: center;
            }

            .visa-image {
                display: none;
                /* Hide decorative images on mobile to save space */
            }
        }

        /* --- NEW FLYER-STYLE HOTEL TABLE STYLING --- */
        .table-responsive {
            overflow-x: auto;
        }

        .flyer-table {
            width: 100%;
            min-width: 950px;
        }

        /* Force horizontal scroll on mobile */

        .flyer-header {
            background-color: var(--header-bg);
            border-radius: 20px 20px 0 0;
            border: 2px solid var(--gold);
            border-bottom: none;
            padding: 15px 20px 10px 20px;
            display: grid;
            grid-template-columns: 38% 17% 45%;
            align-items: flex-end;
            color: #fff;
        }

        .header-title {
            font-family: 'Poppins', sans-serif, cursive;
            font-size: 1.5rem;
            text-transform: uppercase;
            letter-spacing: 1px;
            padding-bottom: 5px;
        }

        .header-title small {
            font-family: 'Poppins', sans-serif;
            font-size: 0.8rem;
            display: block;
            font-weight: 400;
            letter-spacing: 0;
            margin-top: -5px;
        }

        .room-types-header {
            display: grid;
            grid-template-columns: repeat(5, 1fr);
            font-size: 0.8rem;
            color: #e0e0e0;
            text-align: center;
        }

        /* Changed to 5 columns */

        .flyer-body {
            background-image: url('images/smoky-background.png');
            background-size: cover;
            padding: 10px;
            border: 2px solid var(--gold);
            border-top: none;
            border-radius: 0 0 20px 20px;
            color: #fff;
        }

        .hotel-row {
            display: grid;
            grid-template-columns: 38% 17% 45%;
            align-items: center;
            margin-bottom: 8px;
        }

        .hotel-row:last-child {
            margin-bottom: 0;
        }

        .hotel-info-pill {
            color: black;
            padding: 6px 10px;
            margin-right: 10px;
            display: flex;
            align-items: center;
        }

        .hotel-info-pill .icon {
            color: var(--gold);
            margin-right: 8px;
            font-size: 1.1rem;
        }

        .hotel-info-pill .details strong {
            font-size: 0.9rem;
            font-weight: 500;
            display: block;
            line-height: 1.2;
        }

        .hotel-info-pill .details small {
            font-size: 0.7rem;
            color: black;
            display: flex;
            align-items: center;
            margin-top: 2px;
        }

        .hotel-info-pill .details small i {
            font-size: 0.6rem;
            margin-right: 3px;
        }

        .category-cell {
            color: var(--gold);
            font-size: 1.2rem;
            letter-spacing: 3px;
            text-align: center;
        }

        .rates-group {
            display: grid;
            grid-template-columns: repeat(5, 1fr);
            gap: 6px;
        }

        /* Changed to 5 columns */
        .rate-pill {
            color: black;
            padding: 8px 5px;
            text-align: center;
            font-family: 'Oswald', sans-serif;
            font-size: 1.3rem;
            font-weight: 700;
        }

        .rate-pill.na {
            font-family: 'Poppins', sans-serif;
            font-size: 0.9rem;
            font-weight: 500;
        }

        .full-width-message-pill {
            grid-column: 1 / -1;
            background-color: var(--cell-bg);
            border: 2px solid var(--gold);
            border-radius: 15px;
            padding: 8px;
            text-align: center;
            font-weight: 600;
            color: var(--gold);
        }

        @media (max-width: 768px) {
            .page-container {
                padding: 10px;
            }

            .city-section-title {
                font-size: 1.8rem;
            }

            .rate-badge {
                width: 120px;
                height: 75px;
            }

            .rate-badge .price-line {
                font-size: 1.8rem;
            }
        }
    </style>
</head>

<body>

    <div class="page-container">

        <div class="header-banner">
            <img src="images/22.jpg" alt=" RF Travel & Tours Hajj & Umrah Tours">
        </div>


        <!-- VISA PACKAGE RATES SECTION -->
        <?php if ($visa_rates): ?>
            <section class="visa-rates-section">
                <div class="visa-image">
                    <img src="images/makkah-madinah.png" alt="Makkah">
                </div>
                <div class="rates-group-container">
                    <div class="rate-badge">
                        <div class="price-line"><?= round($visa_rates['g4_rate']) ?><span class="currency">SR</span></div>
                        <div class="group-label"><?= htmlspecialchars($visa_rates['g4_pax']) ?> Pax Group</div>
                    </div>
                    <div class="rate-badge">
                        <div class="price-line"><?= round($visa_rates['g3_rate']) ?><span class="currency">SR</span></div>
                        <div class="group-label"><?= htmlspecialchars($visa_rates['g3_pax']) ?> Pax Group</div>
                    </div>
                    <div class="rate-badge">
                        <div class="price-line"><?= round($visa_rates['g2_rate']) ?><span class="currency">SR</span></div>
                        <div class="group-label"><?= htmlspecialchars($visa_rates['g2_pax']) ?> Pax Group</div>
                    </div>
                    <div class="rate-badge">
                        <div class="price-line"><?= round($visa_rates['g1_rate']) ?><span class="currency">SR</span></div>
                        <div class="group-label"><?= htmlspecialchars($visa_rates['g1_pax']) ?> Pax Group</div>
                    </div>
                    <div class="rate-badge">
                        <div class="price-line"><?= round($visa_rates['infant_rate']) ?><span class="currency">SR</span></div>
                        <div class="group-label">Infant Visa</div>
                    </div>
                </div>
                <div class="visa-image">
                    <img src="./images/umrah.png" alt="Madinah">
                </div>
            </section>
        <?php endif; ?>

        <!-- Makkah Hotels Section -->
        <?php if (!empty($makkah_hotels)): ?>
            <section class="city-section">
                <div class="table-responsive">
                    <div class="flyer-table">
                        <div class="flyer-header">
                            <div class="header-title">MAKKAH HOTELS<small>& Locations</small></div>
                            <div class="header-title">CATEGORY</div>
                            <div class="header-title">ROOM TYPES<div class="room-types-header"><span>Sharing</span><span>Quad</span><span>Triple</span><span>Double</span><span>Room</span></div>
                            </div>
                        </div>
                        <div class="flyer-body">
                            <?php foreach ($makkah_hotels as $hotel): ?>
                                <div class="hotel-row">
                                    <div class="hotel-info-pill"><span class="icon"><i class="fa-solid fa-kaaba"></i></span>
                                        <div class="details"><strong style="font-size:1.2rem;"><?= htmlspecialchars($hotel['hotel_name']) ?></strong><small><i class="fa-solid fa-location-dot"></i><?= htmlspecialchars($hotel['location']) ?></small></div>
                                    </div>
                                    <div class="category-cell"><?= render_stars($hotel['star_rating']) ?></div>
                                    <div class="rates-group">
                                        <?php if (!empty($hotel['status_message'])): ?>
                                            <div class="full-width-message-pill"><?= htmlspecialchars($hotel['status_message']) ?></div>
                                        <?php else: // *** ROBUST ERROR FIX APPLIED TO ALL RATES *** ?>
                                            <div class="rate-pill <?= empty($hotel['sharing_rate']) ? 'na' : '' ?>"><?= !empty($hotel['sharing_rate']) ? number_format((float)$hotel['sharing_rate']) : 'N/A' ?></div>
                                            <div class="rate-pill <?= empty($hotel['quad_rate']) ? 'na' : '' ?>"><?= !empty($hotel['quad_rate']) ? number_format((float)$hotel['quad_rate']) : 'N/A' ?></div>
                                            <div class="rate-pill <?= empty($hotel['triple_rate']) ? 'na' : '' ?>"><?= !empty($hotel['triple_rate']) ? number_format((float)$hotel['triple_rate']) : 'N/A' ?></div>
                                            <div class="rate-pill <?= empty($hotel['double_rate']) ? 'na' : '' ?>"><?= !empty($hotel['double_rate']) ? number_format((float)$hotel['double_rate']) : 'N/A' ?></div>
                                            <div class="rate-pill <?= empty($hotel['room']) ? 'na' : '' ?>"><?= !empty($hotel['room']) ? number_format((float)$hotel['room']) : 'N/A' ?></div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </section>
        <?php endif; ?>

        <!-- Madinah Hotels Section -->
        <?php if (!empty($madinah_hotels)): ?>
            <section class="city-section">
                <div class="table-responsive">
                    <div class="flyer-table">
                        <div class="flyer-header">
                            <div class="header-title">MADINA HOTELS<small>& Locations</small></div>
                            <div class="header-title">CATEGORY</div>
                            <div class="header-title">ROOM TYPES<div class="room-types-header"><span>Sharing</span><span>Quad</span><span>Triple</span><span>Double</span><span>Room</span></div>
                            </div>
                        </div>
                        <div class="flyer-body">
                            <?php foreach ($madinah_hotels as $hotel): ?>
                                <div class="hotel-row">
                                    <div class="hotel-info-pill"><span class="icon"><i class="fa-solid fa-mosque"></i></span>
                                        <div class="details"><strong style="font-size:1.2rem;"><?= htmlspecialchars($hotel['hotel_name']) ?></strong><small><i class="fa-solid fa-location-dot"></i><?= htmlspecialchars($hotel['location']) ?></small></div>
                                    </div>
                                    <div class="category-cell"><?= render_stars($hotel['star_rating']) ?></div>
                                    <div class="rates-group">
                                        <?php if (!empty($hotel['status_message'])): ?>
                                            <div class="full-width-message-pill"><?= htmlspecialchars($hotel['status_message']) ?></div>
                                        <?php else: // *** ROBUST ERROR FIX APPLIED TO ALL RATES *** ?>
                                            <div class="rate-pill <?= empty($hotel['sharing_rate']) ? 'na' : '' ?>"><?= !empty($hotel['sharing_rate']) ? number_format((float)$hotel['sharing_rate']) : 'N/A' ?></div>
                                            <div class="rate-pill <?= empty($hotel['quad_rate']) ? 'na' : '' ?>"><?= !empty($hotel['quad_rate']) ? number_format((float)$hotel['quad_rate']) : 'N/A' ?></div>
                                            <div class="rate-pill <?= empty($hotel['triple_rate']) ? 'na' : '' ?>"><?= !empty($hotel['triple_rate']) ? number_format((float)$hotel['triple_rate']) : 'N/A' ?></div>
                                            <div class="rate-pill <?= empty($hotel['double_rate']) ? 'na' : '' ?>"><?= !empty($hotel['double_rate']) ? number_format((float)$hotel['double_rate']) : 'N/A' ?></div>
                                            <div class="rate-pill <?= empty($hotel['room']) ? 'na' : '' ?>"><?= !empty($hotel['room']) ? number_format((float)$hotel['room']) : 'N/A' ?></div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </section>
        <?php endif; ?>

    </div>
</body>

</html>