<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Security checks
if (!isset($_SESSION['user_id']) || !isset($_SESSION['flight_search_results']) || !isset($_SESSION['flight_search_params'])) {
    header('Location: index.php');
    exit();
}

$flight_id = $_GET['flight_id'] ?? null;
if ($flight_id === null || !isset($_SESSION['flight_search_results'][$flight_id])) {
    header('Location: index.php');
    exit();
}

// Get data from session
$flight = $_SESSION['flight_search_results'][$flight_id];
$search_params = $_SESSION['flight_search_params'];

$total_passengers = intval($search_params['adults'] ?? 0) + intval($search_params['children'] ?? 0) + intval($search_params['infants'] ?? 0);

// Set session variables for custom-package.php
$_SESSION['redirect_ticket_price'] = $flight['price'];
$_SESSION['redirect_ticket_pax'] = $total_passengers;

// Redirect to the custom package builder
header('Location: custom-package.php');
exit();
?>